/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CGIResponseWriter.h 2272 2006-12-17 10:21:48Z svn $
 *****************************************************************************/

#ifndef CGI_RESPONSE_WRITER_H
#define CGI_RESPONSE_WRITER_H

#include "Environment.h"

#include <iostream>

#include "apr_file_io.h"

#include "ResponseWriter.h"
#include "CGIResponse.h"

using namespace std;

/**
 * @brief コンソールにでレスポンスを書き出すクラス．
 */
class CGIResponseWriter: public ResponseWriter
{
public:
    CGIResponseWriter(CGIResponse::Handle *r=NULL)
    {

    };
    void write(const char *str, apr_size_t length) const throw()
    {
        cout.write(str, static_cast<streamsize>(length));
#ifdef DEBUG_TemplateExecutor
        cout.flush();
#endif
    };
    void write(const char *str) const throw()
    {
        cout << str;
#ifdef DEBUG_TemplateExecutor
        cout.flush();
#endif
    };
    void write(int i) const throw()
    {
        cout << i;
#ifdef DEBUG_TemplateExecutor
        cout.flush();
#endif
    };
    void finish() const throw()
    {
        cout.flush();
    };
    static int sendfile(CGIResponse::Handle *r,
                        apr_file_t *file, apr_uint64_t length)
    {
        // TODO: 実装する
        return OK;
    };
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
