/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: FlowController.h 2253 2006-12-13 06:00:05Z svn $
 *****************************************************************************/

#ifndef FLOW_CONTROLLER_H
#define FLOW_CONTROLLER_H

#include "Environment.h"

#include <cstdlib>

#include "apr_network_io.h"

#include "Macro.h"
#include "Uncopyable.h"

using namespace std;

/**
 * @brief フロー制御を行うクラスの親クラス．
 */
class FlowController: public Uncopyable
{
protected:
#if APR_HAVE_IPV6
    typedef struct in6_addr address_type;
#else
    typedef struct in_addr  address_type;
#endif

    static const apr_uint32_t *get_address(apr_sockaddr_t *ip_address)
    {
#if APR_HAVE_IPV6
        return AS_UINT32(&(ip_address->sa.sin6.sin6_addr));
#else
        return AS_UINT32(&(ip_address->sa.sin.sin_addr));
#endif
    };
    static apr_size_t get_address_size(apr_sockaddr_t *ip_address)
    {
#if APR_HAVE_IPV6
        return (ip_address->family == APR_INET6)
            ? sizeof(in6_addr) : sizeof(in_addr);
#else
        return sizeof(in_addr);
#endif
    };
    static bool is_address_match(const apr_uint32_t *a, apr_size_t a_size,
                                 const apr_uint32_t *b, apr_size_t b_size)
    {
#if APR_HAVE_IPV6
        apr_size_t word_size;

        if (a_size != b_size) {
            return false;
        }

        word_size = a_size/sizeof(apr_uint32_t);
        for (apr_size_t i = 0; i < word_size; i++) {
            if (a[i] != b[i]) {
                return false;
            }
        }
        return true;
#else
        return (*a == *b);
#endif
    };
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
