#!/usr/bin/env perl

package UploaderTester;
use strict;
use vars qw($VERSION);

$VERSION = 0.01;

use WWW::Mechanize;

sub new {
    my $class = shift;
    my $base_url = shift;

    my $member =  {
        base_url => $base_url,
        mech => WWW::Mechanize->new(),
    };

    $member->{'mech'}->agent_alias('Windows IE 6');

    bless $member, $class;
}

sub upload {
    my $self = shift;
    my $file_path = shift;
    my $comment = shift;
    my $download_pass = shift;
    my $remove_pass = shift;

    $self->{'mech'}->get($self->{'base_url'});
    $self->{'mech'}->form_number(1);
    $self->{'mech'}->set_fields(
        file => $file_path,
        comment => $comment,
        download_pass => $download_pass,
        remove_pass => $remove_pass,
    );

    $self->{'mech'}->submit();

    return $self->{'mech'}->content();
}

sub remove {
    my $self = shift;
    my $item_id = shift;
    my $remove_pass = shift;

    $self->{'mech'}->get($self->{'base_url'});
    $self->{'mech'}->form_number(2);
    $self->{'mech'}->set_fields(
        id => $item_id,
        remove_pass => $remove_pass,
    );

    $self->{'mech'}->submit();

    return $self->{'mech'}->content();
}

sub get_latest_item_id {
    my $self = shift;

    $self->{'mech'}->get($self->{'base_url'});

    foreach (split(/\n/, $self->{'mech'}->content())) {
        m|/download/(\d+)| or next;

        return $1;
    }

    die 'get_latest_item_id failed';
}



# sub create_release {
#     my $self = shift;
#     my $package = shift;
#     my $version = shift;
#     my $file_path = shift;
#     my $file_name  = (split(/[\/\\]/, $file_path))[-1];
#     my @links;


#     @links = $self->get_release_links();

#     if (grep($_->text() eq $file_name, @links)) {
#         die 'Ʊ̾Υ꡼¸ߤޤ';
#     }

#     $self->_mv_create_release_page($package);

#     $self->{'mech'}->form_number(3);
#     $self->{'mech'}->field('release_name', $version);
#     $self->{'mech'}->field('userfile', $file_path);
#     $self->{'mech'}->click();

#     @links = $self->get_release_links();

#     unless (grep($_->text() eq $file_name, @links)) {
#         die '꡼κ˼Ԥޤ';
#     }
# }

# sub get_release_links {
#     my $self = shift;
#     my @links;

#     $self->_mv_list_release_page();

#     @links = grep($_->url() =~ m|\Qhttp://prdownloads.\E|,
#                   $self->{'mech'}->find_all_links());

#     map { $_->[0] }
#         sort { $b->[1] <=> $a->[1] }
#             map { [$_, ($_->text() =~ /([\d.]+)/)[0]] } @links;
# }


# sub _mv_list_release_page {
#     my $self = shift;
#     my $link;

#     $self->{'mech'}->get("/projects/@{[$self->{'project'}]}/admin");

#     $link = $self->{'mech'}->find_link(text => LIST_RELEASE_LINK_LABEL);
#     $self->{'mech'}->get($link->url());

#     if ($self->{'mech'}->content() !~ /\Q@{[LIST_RELEASE_LABEL]}[0]\E/) {
#         die '꡼ΰڡؤΰư˼Ԥޤ';
#     }
# }

# sub _mv_edit_release_page {
#     my $self = shift;
#     my $link;

#     $self->{'mech'}->get("/projects/@{[$self->{'project'}]}/admin");
#     $link = $self->{'mech'}->find_link(text => EDIT_RELEASE_LINK_LABEL);
#     $self->{'mech'}->get($link->url());

#     if ($self->{'mech'}->content() !~ /\Q@{[EDIT_RELEASE_LABEL]}[0]\E/) {
#         die '꡼Խڡؤΰư˼Ԥޤ';
#     }
# }

# sub _mv_create_release_page {
#     my $self = shift;
#     my $package = shift;
#     my $link;
#     my $url;

#     $self->_mv_edit_release_page();
#     $link = $self->{'mech'}->find_link(text => $package);

#     if (! defined $link) {
#         die 'ѥå (' . $package . ') 򸫤ĤޤǤ';
#     }

#     $url = $link->url();
#     $url =~ s/show_edit_package/show_edit_release/;

#     $self->{'mech'}->get($url);

#     if ($self->{'mech'}->content() !~ /\Q@{[CREATE_RELEASE_LABEL]}[0]\E/) {
#         die '꡼οڡؤΰư˼Ԥޤ';
#     }
# }

1;

# Local Variables:
# mode: cperl
# buffer-file-coding-system: euc-japan-unix
# End:
