/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: WriteLocker.h 2381 2007-02-05 16:19:16Z svn $
 *****************************************************************************/

#ifndef WRITE_LOCKER_H
#define WRITE_LOCKER_H

#include "Environment.h"

#include "apr_time.h"
#include "apr_global_mutex.h"

#include "ReadWriteLocker.h"
#include "Macro.h"

#ifdef DEBUG
#include <iostream>
#endif


/**
 * @brief 書き込みロックを表すクラス．
 */
class WriteLocker: public ReadWriteLocker
{
public:
    /**
     * コンストラクタです．
     *
     * @param[out] read_count 読み出し中のスレッドの数
     */
    WriteLocker(apr_atomic_t *read_count)
      : ReadWriteLocker(read_count)
    {
        while (1) {
            if (UNLIKELY(apr_atomic_read(read_count_) != 0)) {
                yield();
                continue;
            }

            if (UNLIKELY(apr_atomic_cas(read_count_, WRITE_LOCKED, 0)
                         == 0)) {
                return;
            }

            yield();
        }
    };
    ~WriteLocker()
    {
        (void)apr_atomic_cas(read_count_, 0, WRITE_LOCKED);
    };
    static bool is_locked(apr_atomic_t *read_count) {
        return apr_atomic_read(read_count) == ReadWriteLocker::WRITE_LOCKED;
    };
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
