/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ReadWriteLocker.cpp 2449 2007-06-29 14:07:48Z svn $
 *****************************************************************************/

#include "Environment.h"

#include "ReadWriteLocker.h"
#include "SourceInfo.h"

SOURCE_INFO_ADD("$Id: ReadWriteLocker.cpp 2449 2007-06-29 14:07:48Z svn $");


/******************************************************************************
 * protected メソッド
 *****************************************************************************/
bool ReadWriteLocker::is_timeout(apr_uint32_t status)
{
    apr_uint32_t curr_age;
    apr_time_t curr_time;

    curr_age = get_age(status);
    curr_time = apr_time_now();

    if (curr_age != start_age_) {
        start_age_ = curr_age;
        start_time_ = curr_time;

        return false;
    }

    if (UNLIKELY(apr_time_sec(curr_time - start_time_) > TIMEOUT_SEC)) {
        return true;
    } else {
        return false;
    }
}

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
