/******************************************************************************
 * Copyright (C) 2007 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: MessageJA.h 2784M 2008-02-10 05:44:37Z (ローカル) $
 *****************************************************************************/

#ifndef MESSAGE_JA_H
#define MESSAGE_JA_H

// MessageJA.h  MessageJA.h.in 鼫ưޤ
// MessageJA.h ľԽʤǤ

#define MESSAGE_ARGUMENT_INVALID            "\xb0\xfa\xbf\xf4\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_BUG_FOUND                   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x42\x55\x47\x5f\x46\x4f\x55\x4e\x44"
#define MESSAGE_CONF_ASSIGN_NEEDED          "\x3d\x20\xa4\xac\xc8\xb4\xa4\xb1\xa4\xc6\xa4\xa4\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_CONF_FILE_NOT_FOUND         "\xc0\xdf\xc4\xea\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xac\xc2\xb8\xba\xdf\xa4\xb7\xa4\xde\xa4\xbb\xa4\xf3\xa1\xa5"
#define MESSAGE_CONF_PARAM_COMPULSORY_NOT_SPECIFIED "\xc9\xac\xbf\xdc\xa5\xd1\xa5\xe9\xa5\xe1\xa1\xbc\xa5\xbf\xa4\xac\xbb\xd8\xc4\xea\xa4\xb5\xa4\xec\xa4\xc6\xa4\xa4\xa4\xde\xa4\xbb\xa4\xf3\xa1\xa5"
#define MESSAGE_CONF_QUOTE_ENDED            "\xa1\xd6\xa1\xc9\xa1\xd7\xa4\xac\xc8\xb4\xa4\xb1\xa4\xc6\xa4\xa4\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_CONF_RETURN_NEEDED          "\xb2\xfe\xb9\xd4\xa4\xac\xc8\xb4\xa4\xb1\xa4\xc6\xa4\xa4\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_CONF_TEMPLATE_INITIALIZE_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x43\x4f\x4e\x46\x5f\x54\x45\x4d\x50\x4c\x41\x54\x45\x5f\x49\x4e\x49\x54\x49\x41\x4c\x49\x5a\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_DATA_DIR_NOT_FOUND          "\xa5\xc7\xa1\xbc\xa5\xbf\xa5\xc7\xa5\xa3\xa5\xec\xa5\xaf\xa5\xc8\xa5\xea\xa4\xac\xb8\xab\xa4\xc4\xa4\xab\xa4\xea\xa4\xde\xa4\xbb\xa4\xf3\xa4\xc7\xa4\xb7\xa4\xbf\xa1\xa5"
#define MESSAGE_DIGEST_STATE_INVALID        "\xa5\xe1\xa5\xc3\xa5\xbb\xa1\xbc\xa5\xb8\xa5\xc0\xa5\xa4\xa5\xb8\xa5\xa7\xa5\xb9\xa5\xc8\xa4\xce\xbe\xf5\xc2\xd6\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_DIR_OPEN_FAILED             "\xa5\xc7\xa5\xa3\xa5\xec\xa5\xaf\xa5\xc8\xa5\xea\xa4\xce\x20\x6f\x70\x65\x6e\x20\xa4\xcb\xbc\xba\xc7\xd4\xa4\xb7\xa4\xde\xa4\xb7\xa4\xbf\xa1\xa5"
#define MESSAGE_DIR_NOT_WRITABLE            "\x4d\x45\x53\x53\x41\x47\x45\x5f\x44\x49\x52\x5f\x4e\x4f\x54\x5f\x57\x52\x49\x54\x41\x42\x4c\x45"
#define MESSAGE_DIR_STAT_FAILED             "\x4d\x45\x53\x53\x41\x47\x45\x5f\x44\x49\x52\x5f\x53\x54\x41\x54\x5f\x46\x41\x49\x4c\x45\x44"

#define MESSAGE_DOWNLOAD_GZIP_NEEDED        "\x67\x7a\x69\x70\x20\xa4\xf2\xa5\xb5\xa5\xdd\xa1\xbc\xa5\xc8\xa4\xb7\xa4\xbf\xa5\xd6\xa5\xe9\xa5\xa6\xa5\xb6\xa4\xac\xc9\xac\xcd\xd7\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_DOWNLOAD_PASS_MISMATCH      "\xa5\xc0\xa5\xa6\xa5\xf3\xa5\xed\xa1\xbc\xa5\xc9\xa5\xd1\xa5\xb9\xa5\xef\xa1\xbc\xa5\xc9\xa4\xac\xb4\xd6\xb0\xe3\xa4\xc3\xa4\xc6\xa4\xa4\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_DOWNLOAD_SESSION_LIMIT_EXCEEDED "\xa5\xc0\xa5\xa6\xa5\xf3\xa5\xed\xa1\xbc\xa5\xc9\xa4\xce\xa5\xbb\xa5\xc3\xa5\xb7\xa5\xe7\xa5\xf3\xbf\xf4\xa4\xac\xc0\xa9\xb8\xc2\xc3\xcd\xa4\xcb\xc3\xa3\xa4\xb7\xa4\xc6\xa4\xa4\xa4\xde\xa4\xb9\xa1\xa5\xa4\xb7\xa4\xd0\xa4\xe9\xa4\xaf\xc2\xd4\xa4\xc3\xa4\xc6\xa4\xab\xa4\xe9\xba\xc6\xc5\xd9\xbb\xee\xa4\xb7\xa4\xc6\xa4\xdf\xa4\xc6\xa4\xaf\xa4\xc0\xa4\xb5\xa4\xa4\xa1\xa5"
#define MESSAGE_ENVIRONMENT_LOCATION_DIR_EXIST "\x6d\x6f\x64\x5f\x75\x70\x6c\x6f\x61\x64\x65\x72\x20\xa4\xf2\xc0\xdf\xc3\xd6\xa4\xb7\xa4\xbf\xbe\xec\xbd\xea\xa4\xc8\xc6\xb1\xa4\xb8\xa5\xd1\xa5\xb9\xa4\xcb\xa5\xc7\xa5\xa3\xa5\xec\xa5\xaf\xa5\xc8\xa5\xea\xa4\xde\xa4\xbf\xa4\xcf\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xac\xc2\xb8\xba\xdf\xa4\xb7\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_FILE_COPY_FAILED            "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\x20\x63\x6f\x70\x79\x20\xa4\xcb\xbc\xba\xc7\xd4\xa4\xb7\xa4\xde\xa4\xb7\xa4\xbf\xa1\xa5"
#define MESSAGE_FILE_DIFFER                 "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xc6\xe2\xcd\xc6\xa4\xac\xb0\xec\xc3\xd7\xa4\xb7\xa4\xde\xa4\xbb\xa4\xf3\xa1\xa5"
#define MESSAGE_FILE_EXT_INVALID            "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xb3\xc8\xc4\xa5\xbb\xd2\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_FILE_MIME_INVALID           "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\x20\x4d\x49\x4d\x45\x20\xa5\xbf\xa5\xa4\xa5\xd7\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_FILE_MMAP_DOUBLED           "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x4d\x4d\x41\x50\x5f\x44\x4f\x55\x42\x4c\x45\x44"
#define MESSAGE_FILE_MMAP_FAILED            "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x4d\x4d\x41\x50\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_MMAP_INVALID_FILE      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x4d\x4d\x41\x50\x5f\x49\x4e\x56\x41\x4c\x49\x44\x5f\x46\x49\x4c\x45"
#define MESSAGE_FILE_NOT_FOUND              "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x4e\x4f\x54\x5f\x46\x4f\x55\x4e\x44"
#define MESSAGE_FILE_OPEN_FAILED            "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x4f\x50\x45\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_PATH_CREATION_FAILED   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x50\x41\x54\x48\x5f\x43\x52\x45\x41\x54\x49\x4f\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_READ_FAILED            "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x52\x45\x41\x44\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_REMOVE_FAILED          "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x52\x45\x4d\x4f\x56\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_RENAME_FAILED          "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x52\x45\x4e\x41\x4d\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_SEEK_FAILED            "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x53\x45\x45\x4b\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_STATE_INVALID          "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x53\x54\x41\x54\x45\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_FILE_STAT_FAILED            "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x53\x54\x41\x54\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_TRUNC_FAILED           "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x54\x52\x55\x4e\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_FILE_WRITE_FAILED           "\x4d\x45\x53\x53\x41\x47\x45\x5f\x46\x49\x4c\x45\x5f\x57\x52\x49\x54\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_HANDLER_COMMAND_INVALID     "\xc9\xd4\xc0\xb5\xa4\xca\xa5\xb3\xa5\xde\xa5\xf3\xa5\xc9\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_HANDLER_PATH_INFO_TOO_LONG  "\x50\x41\x54\x48\x5f\x49\x4e\x46\x4f\x20\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_ICONV_CONVERTER_NOT_FOUND   "\xca\xb8\xbb\xfa\xa5\xb3\xa1\xbc\xa5\xc9\xa4\xce\xca\xd1\xb4\xb9\xa4\xcb\xc9\xac\xcd\xd7\xa4\xca\xa5\xb3\xa5\xf3\xa5\xd0\xa1\xbc\xa5\xbf\xa4\xac\xb8\xab\xa4\xc4\xa4\xab\xa4\xea\xa4\xde\xa4\xbb\xa4\xf3\xa4\xc7\xa4\xb7\xa4\xbf\xa1\xa5"
#define MESSAGE_ICONV_ENCODING_INVALID      "\xca\xb8\xbb\xfa\xa5\xb3\xa1\xbc\xa5\xc9\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_LIST_ID_INVALID             "\x49\x44\x20\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_MANAGER_SHOULD_LOCKED       "\x4d\x45\x53\x53\x41\x47\x45\x5f\x4d\x41\x4e\x41\x47\x45\x52\x5f\x53\x48\x4f\x55\x4c\x44\x5f\x4c\x4f\x43\x4b\x45\x44"
#define MESSAGE_MANAGER_SHOULD_NOT_LOCKED   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x4d\x41\x4e\x41\x47\x45\x52\x5f\x53\x48\x4f\x55\x4c\x44\x5f\x4e\x4f\x54\x5f\x4c\x4f\x43\x4b\x45\x44"
#define MESSAGE_MUTEX_LOCK_FAILED           "\x4d\x45\x53\x53\x41\x47\x45\x5f\x4d\x55\x54\x45\x58\x5f\x4c\x4f\x43\x4b\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_MUTEX_UNLOCK_FAILED         "\x4d\x45\x53\x53\x41\x47\x45\x5f\x4d\x55\x54\x45\x58\x5f\x55\x4e\x4c\x4f\x43\x4b\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_POOL_CREATION_FAILED        "\x4d\x45\x53\x53\x41\x47\x45\x5f\x50\x4f\x4f\x4c\x5f\x43\x52\x45\x41\x54\x49\x4f\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_POST_COMMENT_EMPTY          "\xa5\xb3\xa5\xe1\xa5\xf3\xa5\xc8\xa4\xac\xb6\xf5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_COMMENT_TOO_LONG       "\xa5\xb3\xa5\xe1\xa5\xf3\xa5\xc8\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_DATA_INVALID           "\xc5\xea\xb9\xc6\xa5\xc7\xa1\xbc\xa5\xbf\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_DOWNLOAD_PASS_TOO_LONG "\xa5\xc0\xa5\xa6\xa5\xf3\xa5\xed\xa1\xbc\xa5\xc9\xa5\xd1\xa5\xb9\xa5\xef\xa1\xbc\xa5\xc9\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_DIGEST_EMPTY      "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xa5\xc0\xa5\xa4\xa5\xb8\xa5\xa7\xa5\xb9\xa5\xc8\xa4\xac\xb6\xf5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_DIGEST_TOO_LONG   "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xa5\xc0\xa5\xa4\xa5\xb8\xa5\xa7\xa5\xb9\xa5\xc8\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_EXT_EMPTY         "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xcb\xb3\xc8\xc4\xa5\xbb\xd2\xa4\xac\xc9\xd5\xa4\xa4\xa4\xc6\xa4\xa4\xa4\xde\xa4\xbb\xa4\xf3\xa1\xa5"
#define MESSAGE_POST_FILE_EXT_INVALID       "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xb3\xc8\xc4\xa5\xbb\xd2\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5\xa1\xca\x48\x54\x4d\x4c\x20\xa5\xd5\xa5\xa3\xa5\xeb\xa4\xcf\xa5\xa2\xa5\xc3\xa5\xd7\xa5\xed\xa1\xbc\xa5\xc9\xa4\xc7\xa4\xad\xa4\xde\xa4\xbb\xa4\xf3\xa1\xcb"
#define MESSAGE_POST_FILE_EXT_TOO_LONG      "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xb3\xc8\xc4\xa5\xbb\xd2\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_MIME_EMPTY        "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\x20\x4d\x49\x4d\x45\x20\xa5\xbf\xa5\xa4\xa5\xd7\xa4\xac\xb6\xf5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_MIME_INVALID      "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\x20\x4d\x49\x4d\x45\x20\xa5\xbf\xa5\xa4\xa5\xd7\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_MIME_TOO_LONG     "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\x20\x4d\x49\x4d\x45\x20\xa5\xbf\xa5\xa4\xa5\xd7\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_NAME_EMPTY        "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xcc\xbe\xc1\xb0\xa4\xac\xb6\xf5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_NAME_INVALID      "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xcc\xbe\xc1\xb0\xa4\xcb\xc9\xd4\xc0\xb5\xa4\xca\xca\xb8\xbb\xfa\xa4\xac\xb4\xde\xa4\xde\xa4\xec\xa4\xc6\xa4\xa4\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_NAME_TOO_LONG     "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xcc\xbe\xc1\xb0\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_FILE_SIZE_ZERO         "\xa5\xd5\xa5\xa1\xa5\xa4\xa5\xeb\xa4\xce\xa5\xb5\xa5\xa4\xa5\xba\xa4\xac\x20\x30\x20\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_IMAGE_SIZE_INVALID     "\xb2\xe8\xc1\xfc\xa4\xce\xa5\xb5\xa5\xa4\xa5\xba\xa4\xac\xc9\xd4\xc0\xb5\xa4\xc7\xa4\xb9\xa1\xa5"
#define MESSAGE_POST_INTERVAL_TOO_SHORT     "\xba\xc6\xc5\xea\xb9\xc6\xa4\xde\xa4\xc7\xa4\xce\xb4\xd6\xb3\xd6\xa4\xac\xc3\xbb\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5\xa4\xb7\xa4\xd0\xa4\xe9\xa4\xaf\xc2\xd4\xa4\xc3\xa4\xc6\xa4\xab\xa4\xe9\xa4\xe2\xa4\xa6\xb0\xec\xc5\xd9\xbb\xee\xa4\xb7\xa4\xc6\xa4\xaf\xa4\xc0\xa4\xb5\xa4\xa4\xa1\xa5"
#define MESSAGE_POST_READ_FAILED            "\xc5\xea\xb9\xc6\xa5\xc7\xa1\xbc\xa5\xbf\xa4\xce\xc6\xc9\xa4\xdf\xb9\xfe\xa4\xdf\xa4\xcb\xbc\xba\xc7\xd4\xa4\xb7\xa4\xde\xa4\xb7\xa4\xbf\xa1\xa5"
#define MESSAGE_POST_IP_ADDRESS_GET_FAILED  "\x49\x50\x20\xa5\xa2\xa5\xc9\xa5\xec\xa5\xb9\xa4\xce\xbc\xe8\xc6\xc0\xa4\xcb\xbc\xba\xc7\xd4\xa4\xb7\xa4\xde\xa4\xb7\xa4\xbf\xa1\xa5"
#define MESSAGE_POST_REMOVE_PASS_TOO_LONG   "\xba\xef\xbd\xfc\xa5\xd1\xa5\xb9\xa5\xef\xa1\xbc\xa5\xc9\xa4\xac\xc4\xb9\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_PROGRAM_TOO_OLD             "\xa5\xc7\xa1\xbc\xa5\xbf\xa4\xcb\xc2\xd0\xa4\xb7\xa4\xc6\xa5\xd7\xa5\xed\xa5\xb0\xa5\xe9\xa5\xe0\xa4\xac\xb8\xc5\xa4\xb9\xa4\xae\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_REMOVE_PASS_MISMATCH        "\xba\xef\xbd\xfc\xa5\xd1\xa5\xb9\xa5\xef\xa1\xbc\xa5\xc9\xa4\xac\xb4\xd6\xb0\xe3\xa4\xc3\xa4\xc6\xa4\xa4\xa4\xde\xa4\xb9\xa1\xa5"
#define MESSAGE_RFC1867_CONTENT_SIZE_ZERO   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x31\x38\x36\x37\x5f\x43\x4f\x4e\x54\x45\x4e\x54\x5f\x53\x49\x5a\x45\x5f\x5a\x45\x52\x4f"
#define MESSAGE_RFC1867_CONTENT_TYPE_INVALID "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x31\x38\x36\x37\x5f\x43\x4f\x4e\x54\x45\x4e\x54\x5f\x54\x59\x50\x45\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_RFC1867_DATA_SIZE_TOO_LARGE "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x31\x38\x36\x37\x5f\x44\x41\x54\x41\x5f\x53\x49\x5a\x45\x5f\x54\x4f\x4f\x5f\x4c\x41\x52\x47\x45"
#define MESSAGE_RFC1867_FILE_SIZE_TOO_LARGE "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x31\x38\x36\x37\x5f\x46\x49\x4c\x45\x5f\x53\x49\x5a\x45\x5f\x54\x4f\x4f\x5f\x4c\x41\x52\x47\x45"
#define MESSAGE_RFC1867_FORMAT_INVALID      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x31\x38\x36\x37\x5f\x46\x4f\x52\x4d\x41\x54\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_RFC1867_ITEM_COUNT_EXCEEDED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x31\x38\x36\x37\x5f\x49\x54\x45\x4d\x5f\x43\x4f\x55\x4e\x54\x5f\x45\x58\x43\x45\x45\x44\x45\x44"
#define MESSAGE_RFC1867_TEXT_SIZE_TOO_LARGE "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x31\x38\x36\x37\x5f\x54\x45\x58\x54\x5f\x53\x49\x5a\x45\x5f\x54\x4f\x4f\x5f\x4c\x41\x52\x47\x45"
#define MESSAGE_RFC2822_CONTENT_SIZE_ZERO   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x32\x38\x32\x32\x5f\x43\x4f\x4e\x54\x45\x4e\x54\x5f\x53\x49\x5a\x45\x5f\x5a\x45\x52\x4f"
#define MESSAGE_RFC2822_CONTENT_TYPE_INVALID "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x32\x38\x32\x32\x5f\x43\x4f\x4e\x54\x45\x4e\x54\x5f\x54\x59\x50\x45\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_RFC2822_FILE_SIZE_TOO_LARGE "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x32\x38\x32\x32\x5f\x46\x49\x4c\x45\x5f\x53\x49\x5a\x45\x5f\x54\x4f\x4f\x5f\x4c\x41\x52\x47\x45"
#define MESSAGE_RFC2822_FORMAT_INVALID      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x32\x38\x32\x32\x5f\x46\x4f\x52\x4d\x41\x54\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_RFC2822_HEADER_INVALID      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x32\x38\x32\x32\x5f\x48\x45\x41\x44\x45\x52\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_RFC2822_ITEM_COUNT_EXCEEDED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x32\x38\x32\x32\x5f\x49\x54\x45\x4d\x5f\x43\x4f\x55\x4e\x54\x5f\x45\x58\x43\x45\x45\x44\x45\x44"
#define MESSAGE_RFC2822_TEXT_SIZE_TOO_LARGE "\x4d\x45\x53\x53\x41\x47\x45\x5f\x52\x46\x43\x32\x38\x32\x32\x5f\x54\x45\x58\x54\x5f\x53\x49\x5a\x45\x5f\x54\x4f\x4f\x5f\x4c\x41\x52\x47\x45"
#define MESSAGE_SHM_ATTACH_FAILED           "\x4d\x45\x53\x53\x41\x47\x45\x5f\x53\x48\x4d\x5f\x41\x54\x54\x41\x43\x48\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_SHM_CREATION_FAILED         "\x4d\x45\x53\x53\x41\x47\x45\x5f\x53\x48\x4d\x5f\x43\x52\x45\x41\x54\x49\x4f\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_SHM_SIZE_INVALID            "\x4d\x45\x53\x53\x41\x47\x45\x5f\x53\x48\x4d\x5f\x53\x49\x5a\x45\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_SYS_ATOMIC_INITIALIZE_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x53\x59\x53\x5f\x41\x54\x4f\x4d\x49\x43\x5f\x49\x4e\x49\x54\x49\x41\x4c\x49\x5a\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_SYS_ENV_VARIABLE_INVALID    "\x4d\x45\x53\x53\x41\x47\x45\x5f\x53\x59\x53\x5f\x45\x4e\x56\x5f\x56\x41\x52\x49\x41\x42\x4c\x45\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_SYS_MEMORY_ALLOC_FAILED     "\x4d\x45\x53\x53\x41\x47\x45\x5f\x53\x59\x53\x5f\x4d\x45\x4d\x4f\x52\x59\x5f\x41\x4c\x4c\x4f\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TEST_COMMENT                "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x45\x53\x54\x5f\x43\x4f\x4d\x4d\x45\x4e\x54"
#define MESSAGE_TEST_DOWNLOAD_PASS          ""
#define MESSAGE_TEST_FILE_DIGEST            "\x64\x34\x31\x64\x38\x63\x64\x39\x38\x66\x30\x30\x62\x32\x30\x34\x65\x39\x38\x30\x30\x39\x39\x38\x65\x63\x66\x38\x34\x32\x37\x65"
#define MESSAGE_TEST_IP_ADDRESS             "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x45\x53\x54\x5f\x49\x50\x5f\x41\x44\x44\x52\x45\x53\x53"
#define MESSAGE_TEST_REMOVE_PASS            "\x70\x61\x73\x73"
#define MESSAGE_TMPL_ARITHMETIC_PARSE_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x41\x52\x49\x54\x48\x4d\x45\x54\x49\x43\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_ARRAY_TYPE_MISMATCH    "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x41\x52\x52\x41\x59\x5f\x54\x59\x50\x45\x5f\x4d\x49\x53\x4d\x41\x54\x43\x48"
#define MESSAGE_TMPL_ASSIGN_CALC_FAILED     "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x41\x53\x53\x49\x47\x4e\x5f\x43\x41\x4c\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_ASSIGN_PARSE_FAILED    "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x41\x53\x53\x49\x47\x4e\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_ASSIGN_TYPE_MISMATCH   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x41\x53\x53\x49\x47\x4e\x5f\x54\x59\x50\x45\x5f\x4d\x49\x53\x4d\x41\x54\x43\x48"
#define MESSAGE_TMPL_BROKEN                 "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x42\x52\x4f\x4b\x45\x4e"
#define MESSAGE_TMPL_COMPARE_PARSE_FAILED   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x43\x4f\x4d\x50\x41\x52\x45\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_ELSE_PARSE_FAILED      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x45\x4c\x53\x45\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_EXPR_PARSE_FAILED      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x45\x58\x50\x52\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_FILE_NOT_FOUND         "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x46\x49\x4c\x45\x5f\x4e\x4f\x54\x5f\x46\x4f\x55\x4e\x44"
#define MESSAGE_TMPL_FOREACH_EXEC_FAILED    "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x46\x4f\x52\x45\x41\x43\x48\x5f\x45\x58\x45\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_FOREACH_PARSE_FAILED   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x46\x4f\x52\x45\x41\x43\x48\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_HASH_TYPE_MISMATCH     "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x48\x41\x53\x48\x5f\x54\x59\x50\x45\x5f\x4d\x49\x53\x4d\x41\x54\x43\x48"
#define MESSAGE_TMPL_IF_EXEC_FAILED         "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x49\x46\x5f\x45\x58\x45\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_IF_PARSE_FAILED        "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x49\x46\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_INTEGER_TYPE_MISMATCH  "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x49\x4e\x54\x45\x47\x45\x52\x5f\x54\x59\x50\x45\x5f\x4d\x49\x53\x4d\x41\x54\x43\x48"
#define MESSAGE_TMPL_MULTIPLY_PARSE_FAILED  "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x4d\x55\x4c\x54\x49\x50\x4c\x59\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_PRINT_EXEC_FAILED      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x50\x52\x49\x4e\x54\x5f\x45\x58\x45\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_SCALAR_TYPE_MISMATCH   "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x53\x43\x41\x4c\x41\x52\x5f\x54\x59\x50\x45\x5f\x4d\x49\x53\x4d\x41\x54\x43\x48"
#define MESSAGE_TMPL_STMT_LIST_EXEC_FAILED  "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x53\x54\x4d\x54\x5f\x4c\x49\x53\x54\x5f\x45\x58\x45\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_STMT_PARSE_FAILED      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x53\x54\x4d\x54\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_STRING_ENDED           "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x53\x54\x52\x49\x4e\x47\x5f\x45\x4e\x44\x45\x44"
#define MESSAGE_TMPL_TERM_PARSE_FAILED      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x54\x45\x52\x4d\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_TOKEN_INVALID          "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x54\x4f\x4b\x45\x4e\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_TMPL_UNINITIALIZED_VAR_REFERRED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x55\x4e\x49\x4e\x49\x54\x49\x41\x4c\x49\x5a\x45\x44\x5f\x56\x41\x52\x5f\x52\x45\x46\x45\x52\x52\x45\x44"
#define MESSAGE_TMPL_VARIABLE_ENDED         "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x56\x41\x52\x49\x41\x42\x4c\x45\x5f\x45\x4e\x44\x45\x44"
#define MESSAGE_TMPL_VARIABLE_FORMAT_INVALID "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x56\x41\x52\x49\x41\x42\x4c\x45\x5f\x46\x4f\x52\x4d\x41\x54\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_TMPL_VARIABLE_NAME_INVALID  "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x56\x41\x52\x49\x41\x42\x4c\x45\x5f\x4e\x41\x4d\x45\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_TMPL_VARIABLE_PARSE_FAILED  "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x56\x41\x52\x49\x41\x42\x4c\x45\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_WHILE_EXEC_FAILED      "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x57\x48\x49\x4c\x45\x5f\x45\x58\x45\x43\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_TMPL_WHILE_PARSE_FAILED     "\x4d\x45\x53\x53\x41\x47\x45\x5f\x54\x4d\x50\x4c\x5f\x57\x48\x49\x4c\x45\x5f\x50\x41\x52\x53\x45\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_UPLOAD_ITEM_DIR_OPEN_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x55\x50\x4c\x4f\x41\x44\x5f\x49\x54\x45\x4d\x5f\x44\x49\x52\x5f\x4f\x50\x45\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_UPLOAD_ITEM_FILE_PATH_CREATION_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x55\x50\x4c\x4f\x41\x44\x5f\x49\x54\x45\x4d\x5f\x46\x49\x4c\x45\x5f\x50\x41\x54\x48\x5f\x43\x52\x45\x41\x54\x49\x4f\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_UPLOAD_ITEM_FORMAT_INVALID  "\x4d\x45\x53\x53\x41\x47\x45\x5f\x55\x50\x4c\x4f\x41\x44\x5f\x49\x54\x45\x4d\x5f\x46\x4f\x52\x4d\x41\x54\x5f\x49\x4e\x56\x41\x4c\x49\x44"
#define MESSAGE_UPLOAD_ITEM_SUB_DIR_CREATION_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x55\x50\x4c\x4f\x41\x44\x5f\x49\x54\x45\x4d\x5f\x53\x55\x42\x5f\x44\x49\x52\x5f\x43\x52\x45\x41\x54\x49\x4f\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_UPLOAD_ITEM_SUB_DIR_OPEN_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x55\x50\x4c\x4f\x41\x44\x5f\x49\x54\x45\x4d\x5f\x53\x55\x42\x5f\x44\x49\x52\x5f\x4f\x50\x45\x4e\x5f\x46\x41\x49\x4c\x45\x44"
#define MESSAGE_UPLOAD_ITEM_SUB_DIR_PATH_CREATION_FAILED "\x4d\x45\x53\x53\x41\x47\x45\x5f\x55\x50\x4c\x4f\x41\x44\x5f\x49\x54\x45\x4d\x5f\x53\x55\x42\x5f\x44\x49\x52\x5f\x50\x41\x54\x48\x5f\x43\x52\x45\x41\x54\x49\x4f\x4e\x5f\x46\x41\x49\x4c\x45\x44"

#endif

// Local Variables:
// mode: c++
// coding: euc-japan-dos
// End:
