#!/usr/bin/env zsh

unsetopt FUNCTION_ARGZERO

PACKAGE=`grep AC_INIT configure.in | perl -pe 's/^[^\(]+[^\[]+\[([^\]]+)\].*$/\1/'`
VERSION=`grep AC_INIT configure.in | perl -pe 's/^[^,]+\D+([\d.]+)\D.*$/\1/' | tr '.' '_'`

echo -n 'windows pass: '
read -s WIN_PASS
echo
echo -n 'sourceforge pass: '
read -s SF_PASS
echo

export WIN_PASS
export SF_PASS

run() {
    echo "$0: running \`$@'"
    $@ || exit -1
}

run ./util/win_build.pl

run make -f GNUmakefile.dist dist-sf
run make -f GNUmakefile.dist dist-win-sf

run cp src/mod_uploader-ap2.0.so /home/apache/${PACKAGE}/
run cp src/mod_uploader-ap2.2.so /home/apache/${PACKAGE}/

(
    run cd doc
    run make doc-update
    run make doc-api
    run cp apache.htm apache-win.htm /home/apache/${PACKAGE}/
    run cp -r api /home/apache/${PACKAGE}/
)

(
    run rsync -av --max-size=400000 . ~/cvs/download/${PACKAGE}
    run cd ~/cvs/download/${PACKAGE}
    cvs commit -m ""
    run cvs tag release-${VERSION}_`date "+%y%m%d%H%M"`
)

echo -e "\033[1;32mOK\033[0m";
