/*
 * Decompiled with CFR 0.152.
 */
package mokit.io;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connector;
import mokit.exception.MktIOException;
import mokit.util.ByteUtil;
import mokit.util.StringUtil;

public class PropertyReader {
    private static final String SEPARATOR = " = ";
    private String[] _vals = null;
    private String[] _keys = null;

    public void readResource(String file) throws MktIOException {
        byte[] data;
        InputStream in = null;
        try {
            try {
                in = Connector.openInputStream((String)("resource:///" + file));
                data = ByteUtil.readInputStream(in);
            }
            catch (IOException e) {
                data = null;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (data == null) {
            throw new MktIOException(10, file);
        }
        this.analyzeResource(data);
    }

    private void analyzeResource(byte[] data) {
        String[] lines = StringUtil.split(ByteUtil.byte2Str(data), "\n");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].indexOf("=") != -1) {
                sb.append(String.valueOf(i) + ",");
            }
            ++i;
        }
        String[] tgIdx = StringUtil.split(new String(sb), ",");
        int len = tgIdx.length - 1;
        this._keys = new String[len];
        this._vals = new String[len];
        int i2 = 0;
        while (i2 < len) {
            int idx = Integer.parseInt(tgIdx[i2]);
            String[] params = StringUtil.split(lines[idx], SEPARATOR);
            this._keys[i2] = params[0];
            this._vals[i2] = params[1];
            ++i2;
        }
    }

    public String[] getKeys() {
        return this._keys;
    }

    public String getString(String key) throws MktIOException {
        int i = 0;
        int len = this._keys.length;
        while (i < len) {
            if (this._keys[i].equals(key)) {
                return this._vals[i];
            }
            ++i;
        }
        throw new MktIOException(11, key);
    }
}

