/*
 * Decompiled with CFR 0.152.
 */
package sample;

import mokit.exception.MktUIException;
import mokit.ui.BaseCanvas;
import mokit.ui.G;
import mokit.ui.MktFont;
import mokit.ui.MktImage;
import sample.Main;
import sample.block.Ball;
import sample.block.Bar;
import sample.block.Block;

public class CvsGame
extends BaseCanvas {
    private static String LABEL_TOP = "TOP";
    private static String LABEL_END_APP = "\u7d42\u4e86";
    private static final int[][] STAGE;
    private static final int BLOCK_MAX_COL_NUM = 5;
    public static final int FRAME_SX = 10;
    public static final int FRAME_SY = 10;
    public static final int FRAME_WIDTH = 170;
    public static final int FRAME_HEIGHT = 230;
    private static final int STATUS_NOW_PLAYING = 1;
    private static final int STATUS_CLEAR = 2;
    private static final int STATUS_GAMEOVER = 3;
    private int stage_num = 0;
    private int game_status = 0;
    private int remain_player = 3;
    private int score = 0;
    private int block_max_num = 0;
    private MktImage background;
    private Bar bar;
    private Ball ball;
    private Block[] block;

    static {
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[25];
        nArray[0] = 3;
        nArray[1] = 3;
        nArray[2] = 3;
        nArray[3] = 3;
        nArray[4] = 3;
        nArray[10] = 2;
        nArray[11] = 2;
        nArray[12] = 2;
        nArray[13] = 2;
        nArray[14] = 2;
        nArray[20] = 1;
        nArray[21] = 1;
        nArray[22] = 1;
        nArray[23] = 1;
        nArray[24] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[45];
        nArray2[0] = 3;
        nArray2[1] = 3;
        nArray2[2] = 3;
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[10] = 2;
        nArray2[11] = 2;
        nArray2[12] = 2;
        nArray2[13] = 2;
        nArray2[14] = 2;
        nArray2[20] = 1;
        nArray2[21] = 1;
        nArray2[22] = 1;
        nArray2[23] = 1;
        nArray2[24] = 1;
        nArray2[30] = 3;
        nArray2[31] = 3;
        nArray2[32] = 3;
        nArray2[33] = 3;
        nArray2[34] = 3;
        nArray2[40] = 2;
        nArray2[41] = 2;
        nArray2[42] = 2;
        nArray2[43] = 2;
        nArray2[44] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[55];
        nArray3[0] = 3;
        nArray3[1] = 3;
        nArray3[2] = 3;
        nArray3[3] = 3;
        nArray3[4] = 3;
        nArray3[10] = 2;
        nArray3[11] = 2;
        nArray3[12] = 2;
        nArray3[13] = 2;
        nArray3[14] = 2;
        nArray3[20] = 1;
        nArray3[21] = 1;
        nArray3[22] = 1;
        nArray3[23] = 1;
        nArray3[24] = 1;
        nArray3[30] = 3;
        nArray3[31] = 3;
        nArray3[32] = 3;
        nArray3[33] = 3;
        nArray3[34] = 3;
        nArray3[40] = 2;
        nArray3[41] = 2;
        nArray3[42] = 2;
        nArray3[43] = 2;
        nArray3[44] = 2;
        nArray3[50] = 1;
        nArray3[51] = 1;
        nArray3[52] = 1;
        nArray3[53] = 1;
        nArray3[54] = 1;
        nArrayArray[2] = nArray3;
        STAGE = nArrayArray;
    }

    public CvsGame() {
        this.initStage(0);
    }

    public void activateCvs() {
        this.setSoftLabel(LABEL_TOP, LABEL_END_APP);
    }

    public void initStage(int num) {
        this.block_max_num = STAGE[num].length;
        this.ball = new Ball();
        this.bar = new Bar();
        this.block = new Block[this.block_max_num];
        int i = 0;
        while (i < this.block_max_num) {
            this.block[i] = new Block(i % 5, i / 5, STAGE[num][i]);
            ++i;
        }
        this.background = new MktImage();
        try {
            if (this.stage_num % 3 == 0) {
                this.background.setImage("sky.gif");
            } else if (this.stage_num % 3 == 1) {
                this.background.setImage("sky2.gif");
            } else if (this.stage_num % 3 == 2) {
                this.background.setImage("sky3.gif");
            }
        }
        catch (MktUIException e) {
            e.printStackTrace();
        }
        i = 0;
        while (i < this.stage_num) {
            this.ball.speedUp();
            ++i;
        }
        this.game_status = 1;
    }

    public void paintCvs() {
        MktFont.setFont(MktFont.FONT_TINY);
        G.drawImage(this.background, 0, 0);
        G.setColorRGB(0, 0, 0, 50);
        G.fillRect(10, 10, 170, 230);
        G.setColorRGB(220, 220, 220);
        G.drawRect(9, 9, 171, 231);
        int fx = 198;
        int fy = 40;
        G.drawBorderString("SCORE", fx, fy, new int[3], new int[]{255, 255, 255});
        String _score = "" + this.score;
        int i = _score.length();
        while (i < 5) {
            _score = " " + _score;
            ++i;
        }
        int[] nArray = new int[3];
        nArray[0] = 255;
        G.drawBorderString(_score, fx, fy + 20, nArray, new int[]{255, 255, 255});
        G.drawBorderString(" \u6b8b\u308a", fx, 180, new int[3], new int[]{255, 255, 255});
        i = 0;
        while (i < this.remain_player - 1) {
            G.drawImage(this.ball.getImage(), fx + i * 15, 190);
            ++i;
        }
        this.bar.paint();
        this.ball.paint();
        i = 0;
        while (i < this.block_max_num) {
            this.block[i].paint();
            ++i;
        }
        if (this.game_status == 2) {
            String str_clear = "STAGE CLEAR !";
            int[] nArray2 = new int[3];
            nArray2[2] = 255;
            G.drawBorderString(str_clear, 90 - MktFont.getFontSize(str_clear)[0] / 2, 115, nArray2, new int[]{255, 255, 255});
        } else if (this.game_status == 3) {
            String str_clear = "GAME OVER";
            int[] nArray3 = new int[3];
            nArray3[0] = 255;
            G.drawBorderString(str_clear, 90 - MktFont.getFontSize(str_clear)[0] / 2, 115, nArray3, new int[]{255, 255, 255});
        }
    }

    public void exe(int keyEvent, int keyState) {
        if (keyEvent == 21) {
            this.endCvsThread(Main.MODE_TITLE);
        }
        if (keyEvent == 22) {
            this.endCvsThread(Main.MODE_END_APP);
        }
        if (this.game_status == 1) {
            if (this.checkKey(16)) {
                this.ball.moveWithBar(this.bar.moveLeft());
            } else if (this.checkKey(18)) {
                this.ball.moveWithBar(this.bar.moveRight());
            }
            if (keyEvent == 20) {
                this.ball.start();
            }
            this.updateStatus();
        } else if (this.game_status == 2 && keyEvent == 20) {
            this.initStage(++this.stage_num);
        }
    }

    public void updateStatus() {
        this.ball.move();
        this.ball.chkBarHit(this.bar);
        int remain_num = 0;
        int i = 0;
        while (i < this.block_max_num) {
            if (!this.block[i].isHit()) {
                ++remain_num;
                if (this.ball.chkBlockHit(this.block[i])) {
                    this.block[i].hit();
                    this.score += this.block[i].getScore();
                }
            }
            ++i;
        }
        if (remain_num == 0) {
            this.game_status = 2;
            this.bar.init();
            this.ball.init();
        }
        if (this.ball.chkOut()) {
            if (this.remain_player-- > 1) {
                this.bar.init();
                this.ball.init();
                i = 0;
                while (i < this.stage_num) {
                    this.ball.speedUp();
                    ++i;
                }
            } else {
                this.game_status = 3;
            }
        }
    }
}

