#!/bin/bash
# Make One Linux on Linux File System
# Written by Keicho Kondo 2006.04.03
# Contact: dgel@users.sourceforge.jp
# License GPL

# ChangeLog
# 2006-04-03 Keicho Kondo
# - Modify unsetup.bat called from install2win.bat for Linux System.

# get information from Make One Linux System
MOLFLAG="${0%/*}/MOLFLAG"
if [ -f "${MOLFLAG}" ]
then
	. ${MOLFLAG}
else
	MOLVERSION="x.x.x"
	KERNEL_RELEASE="mol-${MOLVERSION}"
fi

# set title
OLTITLE="MakeOneLinux ${MOLVERSION} (Overlaying Mode)"
ROTITLE="MakeOneLinux ${MOLVERSION} (Read-Only Mode)"

# configure boot loader
grubby --remove-kernel TITLE="${OLTITLE}" >/dev/null 2>&1
grubby --remove-kernel TITLE="${ROTITLE}" >/dev/null 2>&1

