/*!
    \file   MoIp.cpp
    \brief  IPvgRNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.4 $
    \date   create:2004/09/20 update:$Date: 2004/11/23 14:29:04 $
*/

/*! \class MoIp
 *  \brief IPvgRNX
 */



#include "MoIp.h"
#include "MonesConfig.h"
#include "MonesGlobal.h"

/*!
    \brief initialize
         MoIp RXgN^
    \author Yamami
    \date   create:2004/09/20 update:
*/
MoIp::MoIp()
{

}

/*!
    \brief initialize
         MoIp initIp
    \author Yamami
    \param  AbstractMonic *pminsNic [in] NICNXւ̃|C^
    \date   create:2004/09/20 update:
*/
void MoIp::initIp(AbstractMonic *pminsNic ) 
{
    //NICNXێ
    insAbstractNic = pminsNic;
    return;
}


/*!
    \brief initialize
         MoIp fXNgN^
    \author Yamami
    \date   create:2004/08/20 update:
*/
MoIp::~MoIp() 
{

}


/*!
    \brief receiveIp
         IPvgRM 
    \param  IP_HEADER *ipHead [in] IPwb_ւ̃|C^
    \return int  
        
    \author Yamami
    \date   create:2004/09/20 update:2004/09/20
*/
int MoIp::receiveIp(IP_HEADER *ipHead)
{

    /* `FbNT̊mFB */
    if(MoPacUtl::calcCheckSum((dword*)ipHead,(ipHead->verhead&0xf)*4)){
        return 0;
    }

    /* ʃvgR֓nB */
    switch(ipHead->prot)
    {
        //case IPPROTO_TCP:
        //  return g_MoIcmp->receiveTcp(ipHead);
        //case IPPROTO_UDP:
        //  return g_MoIcmp->receiveUdp(ipHead);
        case IPPROTO_ICMP:
          return g_MoIcmp->receiveIcmp(ipHead);
    }

    return 0;
}


/*!
    \brief transIp
         IPvgRM 
    \param  TRANS_BUF_INFO *tbi [in] Mobt@\̂ւ̃|C^
    \param  dword dstip [in] MIPAhX(GfBAϊς݂O)
    \param  byte tos [in] T[rX^Cv
    \param  int flag [in] tO
    \return int  

    \author Yamami
    \date   create:2004/09/20 update:2004/09/20
*/
int MoIp::transIp(TRANS_BUF_INFO *tbi, dword dstip, byte tos, int flag)
{

    byte *transPacket; //pPbgMobt@

    byte dstmac[6];
    dword transip;
    //int num;
    int rest;
    IP_HEADER ipHead;
    int max,total;
    //int trans;

    int ret;
    //[eBO
    ret = ipRouting(dstip , &transip);
    //transip = dstip;

    // M MACAhX擾(ARP)
    if((rest=g_MoArp->getMac(transip,dstmac)) != 0){
        //ARPLbVł͌炸AIPM͂ɂłȂ̂ŁA҂
        //pPbge҂Xg֒ǉ
        MAC_REPLY_WAIT* nowWait;
        nowWait = g_MoArp->macWaitList->get(rest-1);
        nowWait->ipPacketBuf = tbi;
        
        //Yamami fobO
        printf("MoIp::transIp rest = %d!!\n",rest);
        
        return rest;
    }

    //IPwb_쐬B
    ipHead.verhead=IP_HEAD_VERSION|(sizeof(IP_HEADER)/4);
    ipHead.tos=tos;
    
    //GET_ID(ipHead.id);
    //Yamami ̓XbhZ[tɂKvH
    ipHead.id++;
    
    ipHead.ttl=255;
    ipHead.prot=tbi->ipType;
    ipHead.srcip=MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr());
    ipHead.dstip=dstip;
    ipHead.chksum=0;

    //MTBL
    tbi->type=ETHER_PROTO_IP;
    tbi->data[0]=(char*)&ipHead;
    tbi->size[0]=sizeof(IP_HEADER);         // IP header size.
    //max=ethDev[num].mtu-sizeof(IP_HEADER);  // f[^ő呗MTCYB
    max=G_MonesCon.getGl_myMTU()-sizeof(IP_HEADER);  // f[^ő呗MTCYB
    total=tbi->size[1]+tbi->size[2];        // f[^g[^TCYB

    if(total<=max)
    {
        
        
        //MvpPbgTCYMTUȉȂ
        //IPTCY
        ipHead.len=MoPacUtl::swapShort(tbi->size[0]+total);
        //tO
        ipHead.frag=MoPacUtl::swapShort(flag<<14);
        //`FbNT
        ipHead.chksum=MoPacUtl::calcCheckSum((dword*)&ipHead,tbi->size[0]);
        
        //NICgđM!        
        //pPbg쐬
        transPacket = (byte *)malloc(sizeof(IP_HEADER) + total);
        memcpy(transPacket,(byte *)&ipHead,sizeof(ipHead));
        memcpy(transPacket + sizeof(ipHead),tbi->data[1],tbi->size[1]);
        
        insAbstractNic->frame_output(transPacket , (byte *)dstmac , sizeof(IP_HEADER) + total , ETHER_PROTO_IP);
        
        //pPbgobt@
        free(transPacket);
    }

/*
    else
    {
        //MvpPbgTCYMTUȏȂ  
        ipHead.len=swapWord(tbi->size[0]+max);
        ipHead.frag=swapWord(IP_HEAD_FRAG_ON);
        tbi->size[2]=max-tbi->size[1];
        ipHead.chksum=calcSum((uint*)&ipHead,tbi->size[0]);
        ethDev[num].dev->write(ethDev[num].dev->linf,(size_t)tbi,(size_t)dstmac);

        trans=max;                      // MσTCY
        tbi->data[2]+=max-tbi->size[1];
        tbi->size[1]=0;

        for(;;)
        {
            ipHead.chksum=0;

            if(total-trans<=max)
            {
                ipHead.len=swapWord(tbi->size[0]+total-trans);
                ipHead.frag=swapWord(trans);
                GET_ID(ipHead.id);
                ipHead.chksum=calcSum((uint*)&ipHead,tbi->size[0]);
                tbi->size[2]=total-trans;
                ethDev[num].dev->write(ethDev[num].dev->linf,(size_t)tbi,(size_t)dstmac);
                break;
            }
            else
            {
                ipHead.len=swapWord(tbi->size[0]+max);
                ipHead.frag=swapWord(trans|IP_HEAD_FRAG_ON);
                GET_ID(ipHead.id);
                ipHead.chksum=calcSum((uint*)&ipHead,tbi->size[0]);
                tbi->size[2]=max;
                ethDev[num].dev->write(ethDev[num].dev->linf,(size_t)tbi,(size_t)dstmac);
            }

            trans+=max;
            tbi->data[2]+=max;
        }
    }
*/

    return 0;
}


 
/*!
    \brief ipRouting
         IP[eBO 
    \param  word ip [in] MIPAhX
    \param  dword dstip [in] ]IPAhX(̃TulbgȂ烋[^ƂȂ)
    \return int  

    \author Yamami
    \date   create:2004/10/30 update:2004/10/30
*/
int MoIp::ipRouting(dword ip,dword *transip)
{

    //Tulbg`FbNB
    if((ip & MoPacUtl::swapLong(G_MonesCon.getGl_mySubnet())) 
        == (MoPacUtl::swapLong(G_MonesCon.getGl_myIpAdr()) & MoPacUtl::swapLong(G_MonesCon.getGl_mySubnet())))
    {
        *transip=ip;
        return 0;
    }

    /* ftHgQ[gEFCցB */
    *transip=MoPacUtl::swapLong(G_MonesCon.getGl_myGw());
    return 0;
}
