/*!
  \file  mones.cpp
  \brief Code:MonesC

  Copyright (c) 2004 Yamami
  All rights reserved.
  License=MIT/X Licnese

  \author  Yamami
  \version $Revision: 1.7 $
  \date   create:2004/08/08 update:$Date: 2004/12/09 07:57:18 $
*/


//ŁAMones̃O[oIuWFNgCX^X
#define MONES_GLOBAL_VALUE_DEFINED
#include "MonesGlobal.h"

#include <monapi.h>
#include "AbstractMonic.h"
#include "MoEther.h"
#include "MoIcmp.h"
#include "MonesConfig.h"
#include "MonesLoader.h"



using namespace MonAPI;


/*!
    \brief MonaMain
        Code:MonesC

    \param List<char*>* pekoe

    \author  Yamami
    \date    create:2004/08/08 update:2004/10/31
*/
int MonaMain(List<char*>* pekoe)
{
    
    //TO DO Ƃ肠A30vZX܂OK 
    MonesRList = new HList<MONES_IP_REGIST*>();
    MONES_IP_REGIST *regist;
    
    //syscall_get_io  
    //̃vZX쒆́AIOx3܂ŋ
    syscall_get_io();
    
    // NIC̃CX^X
    // MonesLoaderNXoRŃCX^XB
    AbstractMonic* insAbstractNic;
    
    MonesLoader* insNicLoader = new MonesLoader();
    insNicLoader->setup();
    insAbstractNic = insNicLoader->getNicInstance();
    //NIC̃[hɎsꍇ́AMonesI
    if(insAbstractNic == 0){
        printf("NIC Error Mones Quit \n");
        return 0;
    }
    
    //EtherNX̃CX^X
    g_MoEther = new MoEther();
    g_MoEther->etherInit(insAbstractNic);

    //ARPNX̃CX^X
    g_MoArp = new MoArp();
    g_MoArp->initArp(insAbstractNic);

    //IPNX̃CX^X
    g_MoIp = new MoIp();
    g_MoIp->initIp(insAbstractNic);


    // initilize destination list
    //List<dword>* destList = new HList<dword>();
    MessageInfo info;

    // Server start ok
    dword targetID = Message::lookupMainThread("MONITOR.BIN");
    if (targetID == 0xFFFFFFFF)
    {
        printf("Mones:INIT not found\n");
        exit(1);
    }

    // create message
    Message::create(&info, MSG_SERVER_START_OK, 0, 0, 0, NULL);

    // send
    if (Message::send(targetID, &info)) {
        printf("Mones:INIT error\n");
    }

    //lbg[NIRQ}XNEnable
    insAbstractNic->enableNetWork();

    //IRQV[oƂēo^ (IRQ́ANIChCoNX蓾)
    syscall_set_irq_receiver(insAbstractNic->getNicIRQ());

    /* Message loop */
    //ŃbZ[W[v
    for (;;)
    {
        /* receive */
        if (!Message::receive(&info))
        {
            
            switch(info.header)
            {
            case MSG_INTERRUPTED:
                
                //printf("MSG_INTERRUPTED\n");
                
                dword    i;
                
                //pPbgM
                insAbstractNic->frame_input();
                
                //EtherNXɓo^
                i = g_MoEther->setEtherFrame(insAbstractNic->frame_buf ,insAbstractNic->frame_len);
                //C[Tlbgt[M
                i = g_MoEther->receiveEther();
                
                break;


            //Mones֓o^
            case MSG_MONES_REGIST:
            //case 5:
                
                printf("MSG_MONES_REGIST\n");
                
                //ʐMǗXgɓo^
                //TO DO TCPT|[g΁A{́AIPł͖A|[gԍ
                regist = new MONES_IP_REGIST();
                regist->tid = info.from;
                regist->ip = info.arg1;
                
                MonesRList->add(regist);
                
                break;


            //Yamami!! TO DO pPbgMA
            //AṽpPbgMv
            case MSG_MONES_IP_SEND:
                //pPbgM
                //TO DO PɁAŃeXgpIPpPbg쐬Mv
                printf("MSG_MONES_IP_SEND\n");
                
                int ret;
                dword ip;
                TRANS_BUF_INFO *tbi;
                tbi = new TRANS_BUF_INFO();
                
                ICMP_HEADER *icmpHead;
                icmpHead = new ICMP_HEADER();
                
                //testPacket = new char(100);
                
                //M 10.0.2.2(QEMU GW)
                ip = 0x0A000202;
                
                
                //ICMPwb_[̐ݒ
                icmpHead->type=ICMP_TYPE_ECHOREQ;
                icmpHead->code=0;
                icmpHead->chksum=0;
                //icmpHead->chksum=MoPacUtl::calcCheckSum((dword*)icmpHead,size);
                icmpHead->chksum=MoPacUtl::calcCheckSum((dword*)icmpHead,0);

                //Mobt@e[u̐ݒ
                tbi->data[2]=NULL;
                tbi->size[2]=0;
                tbi->data[1]=(char*)icmpHead;
                //tbi->size[1]=size;
                tbi->size[1]=0;
                tbi->ipType=IPPROTO_ICMP;
    
                ret = g_MoIp->transIp(tbi , MoPacUtl::swapLong(ip) ,0, 0);

                //TODO ̃^C~OlȂƃ[N !!
                //delete icmpHead;
                //delete tbi;
                
                break;

            //ARP҂Wake Up
            case MSG_MONES_WAKEUP_ARP_WAIT:
                
                printf("MSG_MONES_WAKEUP_ARP_WAIT\n");
                
                MAC_REPLY_WAIT* nowWait;
                
                //ARPv҂Xǧ
                for (int i = 0; i < g_MoArp->macWaitList->size() ; i++) {
                    nowWait = g_MoArp->macWaitList->get(i);
                    
                    if(nowWait->repFlg == 1){
                        //ARPς݂ȂA҂pPbg𑗐MB
                        ret = g_MoIp->transIp(nowWait->ipPacketBuf , nowWait->ip ,0, 0);
                        
                        //ҔĂIPpPbgobt@̉
                        free(nowWait->ipPacketBuf);
                        
                        //҂Xg폜
                        g_MoArp->macWaitList->removeAt(i);
                        //JE^fNgB
                        i--;
                    }
                }
                

                
                break;

            default:
                /* igonore this message */
                break;
            }

        }
    }
    return 0;
}

