package guibuilder;

import java.awt.*;
import java.awt.event.*;

/**
 AvP[VEBhEB
 j[c[o[ȂǂĂB
 */
public class ApplicationWindow extends Frame implements WindowListener, ActionListener {
	/** Ώ */
	private IParts target = null;
	/** EBhEi */
	private PWindow pWindow = null;
	/** c[o[ */
	private ApplicationToolbar applitacionToolbar = null;
	/** vpeBo[ */
	private ApplicationPropertybar applitacionPropertybar = null;
	/** t@CۑNX */
	private FileMaker fileMaker = null;
	
	/** RXgN^ */
	public ApplicationWindow() {
		super(IParts.title);
		setSize(640, 480);
		setResizable(false);
		setVisible(true);
		// GIFAvP[VACRɐݒ肵Ă
		setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/resources/mona.gif")));
	}
	
	/** iɌĂ΂ */
	public void create() {
		addWindowListener(this);
		setLayout(null);
		
		// j[̒`
		MenuBar menuBar = new MenuBar();
		Menu fileMenu = new Menu("t@C");
		Menu editMenu = new Menu("ҏW");
		Menu helpMenu = new Menu("wv");
		fileMenu.add(new MenuItem("VK", new MenuShortcut(KeyEvent.VK_N, false)));
		fileMenu.add(new MenuItem("ۑ", new MenuShortcut(KeyEvent.VK_S, false)));
		fileMenu.add(new MenuItem("I", new MenuShortcut(KeyEvent.VK_Q, false)));
		editMenu.add(new MenuItem("폜", new MenuShortcut(KeyEvent.VK_D, false)));
		helpMenu.add(new MenuItem("o[W", new MenuShortcut(KeyEvent.VK_V, false)));
		fileMenu.addActionListener(this);
		editMenu.addActionListener(this);
		helpMenu.addActionListener(this);
		menuBar.add(fileMenu);
		menuBar.add(editMenu);
		menuBar.add(helpMenu);
		setMenuBar(menuBar);
		
		// c[o[
		applitacionToolbar = new ApplicationToolbar();
		add(applitacionToolbar);
		applitacionToolbar.create();
		applitacionToolbar.repaint();
		
		// vpeBo[
		applitacionPropertybar = new ApplicationPropertybar();
		add(applitacionPropertybar);
		applitacionPropertybar.create();
		applitacionPropertybar.repaint();
		
		// t@CۑNX
		fileMaker = new FileMaker();
	}

	/** EBhEi𓾂 */
	public PWindow getPWindow() {
		return pWindow;
	}
	
	/** c[o[𓾂 */
	public ApplicationToolbar getApplicationToolbar() {
		return applitacionToolbar;
	}
	
	/** vpeBo[𓾂 */
	public ApplicationPropertybar getApplicationPropertybar() {
		return applitacionPropertybar;
	}
	
	/** iXV */
	public void update(IParts parts) {
		this.target = parts;
		applitacionPropertybar.update(parts);
	}

	//
	// WindowListener
	//
	public void windowActivated(WindowEvent e) {}
	public void windowClosed(WindowEvent e) {}
	public void windowClosing(WindowEvent e) { System.exit(0); }
	public void windowDeactivated(WindowEvent e) {}
	public void windowDeiconified(WindowEvent e) {}
	public void windowIconified(WindowEvent e) {}
	public void windowOpened(WindowEvent e) {}

	//
	// ActionListener
	//
	public void actionPerformed(ActionEvent e) {
		if (e.getActionCommand().equals("VK")) {
			if (pWindow == null) {
				pWindow = new PWindow();
				add(pWindow);
				pWindow.create();
				pWindow.repaint();
			} else {
				MessageDialog dialog = new MessageDialog(this, "G[", 
					new String[] {"łɃEBhE", "쐬Ă܂B"});
				dialog.show();
			}
		} else if (e.getActionCommand().equals("ۑ") && pWindow != null) {
			if (pWindow != null) {
				fileMaker.writeFile(pWindow);
				MessageDialog dialog = new MessageDialog(this, "ۑ", 
					new String[] {"ۑ܂B"});
				dialog.show();
			}
		} else if (e.getActionCommand().equals("I")) {
			System.exit(0);
		} else if (e.getActionCommand().equals("폜")) {
			if (pWindow != null && target != null) {
				// EBhE폜
				if (target == pWindow) {
					System.out.println("remove(" + target.getName() + ")");
					Component[] list = pWindow.getComponents();
					for (int i = 0; i < pWindow.getComponentCount(); i++) {
						IParts p = (IParts)list[i];
						p.dispose();
					}
					pWindow.dispose();
					remove(pWindow);
					pWindow = null;
				// i폜
				} else {
					System.out.println("remove(" + target.getName() + ")");
					target.dispose();
					pWindow.remove((Component)target);
				}
				target = null;
				repaint();
			}
		} else if (e.getActionCommand().equals("o[W")) {
			MessageDialog dialog = new MessageDialog(this, "o[W", 
				new String[] {IParts.title, "Copyright (C) 2005, bayside."});
			dialog.show();
		}
	}
}
