/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#if !defined(_EVENT_H_INCLUDED_)
#define _EVENT_H_INCLUDED_

namespace baygui {
	class Component;

	/**
	 CxgNX
	*/
	class Event : public Object {
	public:
		//
		// Cxg^Cvꗗ
		//
		/** L[ */
		static const int KEY_PRESSED     = 100;
		/** L[[X */
		static const int KEY_RELEASED    = 101;
		/** }EXNbN */
		static const int MOUSE_PRESSED   = 200;
		/** }EX[X */
		static const int MOUSE_RELEASED  = 201;
		/** }EXhbO */
		static const int MOUSE_DRAGGED   = 202;
		/** }EXړ */
		static const int MOUSE_MOVED     = 203;
		/** tH[JXC */
		static const int FOCUS_IN        = 300;
		/** tH[JXAEg */
		static const int FOCUS_OUT       = 301;
		/** ^C}[ */
		static const int TIMER           = 302;
		/** eLXgm */
		static const int TEXT_CHANGED    = 303;
		/** ڑI */
		static const int ITEM_SELECTED   = 304;
		/** ubN */
		static const int BLOCK_INCLEMENT = 305;
		/** ubN */
		static const int BLOCK_DECLEMENT = 306;
		/** JX^Cxg */
		static const int CUSTOM_EVENT    = 400;
		
	private:
		/** Cxg^Cv */
		int type;
		/** Cxg */
		Component* source;

	public:
		//
		// MonapCxg
		//
		/** wb_[ */
		dword header;
		/** (1) */
		dword arg1;
		/** (2) */
		dword arg2;
		/** (3) */
		dword arg3;
		/** bZ[W */
		dword from;
		/**  */
		char str[128];
		/** ̒ */
		int length;

	public:
		/** ftHgRXgN^ */
		Event() {
			this->type = CUSTOM_EVENT;
			this->source = NULL;
		}
		
		/**
		 RXgN^
		 @param type Cxg^Cv
		 @param source Cxgi
		 */
		Event(int type, Component* source) {
			this->type = type;
			this->source = source;
		}
		
		/** fXgN^ */
		virtual ~Event() {}
		
		/** Cxg^Cv𓾂 */
		inline int getType() { return this->type; }
		
		/** Cxg^Cvݒ肷 */
		inline void setType(int type) { this->type = type; }
		
		/** Cxg̔i𓾂 */
		inline Component* getSource() { return this->source; }
		
		/** Cxg̔iݒ肷 */
		inline void setSource(Component* c) { this->source = c; }
	};
}

#endif // _EVENT_H_INCLUDED_
