/*
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#if !defined(_GRAPHICS_H_INCLUDED_)
#define _GRAPHICS_H_INCLUDED_

namespace baygui {
	/**
	 `NX
	*/
	class Graphics : public Object {
	private:
		/** `JnXW */
		int tx;
		/** `JnYW */
		int ty;
		/** NbsÖXW */
		int cx;
		/** NbsÖYW */
		int cy;
		/** NbsÖ敝 */
		int cw;
		/** NbsÖ捂*/
		int ch;
		/** Fi4oCgj */
		dword rgb24;
		/** tHgX^C */
		int fontStyle;
		/** obt@[ */
		Image* image;

	public:
		/** RXgN^ */
		Graphics();

		/**
		 RXgN^
		 @param image obt@[
		*/
		Graphics(Image* image);
		
		/** fXgN^ */
		virtual ~Graphics();
		
		/**
		 _`
		 @param x XW
		 @param y YW
		 @param color `悷F
		 */
		void drawPixel(int x, int y, dword color);
		
		/**
		 C[W`
		 @param image C[W
		 @param x `JnXW
		 @param y `JnYW
		 */
		void drawImage(Image* image, int x, int y);
		
		/**
		 `
		 @param x0 n_X
		 @param y0 n_Y
		 @param x1 I_X
		 @param y1 I_Y
		 */
		void drawLine(int x0, int y0, int x1, int y1);
		
		/**
		 ``
		 @param x n_X
		 @param y n_Y
		 @param width 
		 @param height 
		 */
		void drawRect(int x, int y, int width, int height);
		
		/**
		 ~`
		 @param x0 SX
		 @param y0 SY
		 @param r  a
		 */
		void drawCircle(int x0, int y0, int r);
		
		/**
		 `
		 @param str isΉj
		 @param x n_X
		 @param y n_Y
		 */
		void drawString(String* str, int x, int y);
		
		/**
		 `
		 @param str isΉj
		 @param x n_X
		 @param y n_Y
		 */
		void drawString(const String& str, int x, int y);
		
		/**
		 ~hԂ`
		 @param x0 SX
		 @param y0 SY
		 @param r  a
		 */
		void fillCircle(int x0, int y0, int r);
		
		/**
		 `ʂԂ`
		 @param x n_X
		 @param y n_Y
		 @param width 
		 @param height 
		 */
		void fillRect(int x, int y, int width, int height);
		
		/**
		 Wݒ
		 @param x n_X
		 @param y n_Y
		 */
		void translate(int x, int y);
		
		/** tHgX^C𓾂 */
		inline int getFontStyle() { return this->fontStyle; }
		
		/**
		 NbsÖݒ
		 @param cx n_X
		 @param cy n_Y
		 @param cw I_X
		 @param ch I_Y
		 */
		void setClip(int cx, int cy, int cw, int ch);
		
		/**
		 Fݒ
		 @param r (0-255)
		 @param g (0-255)
		 @param b (0-255)
		 */
		void setColor(unsigned char r, unsigned char g, unsigned char b);
		
		/**
		 Fݒ
		 @param color (0x0-0xFFFFFF)
		 */
		void setColor(dword color);
		
		/**
		 tHgX^CiʏAAΎAŒ蕝jݒ肷.
		 eX^C"|"őgݍ킹邱Ƃ\B
		 @param style tHgX^C (Font::PLAIN / Font::BOLD / Font::ITALIC / Font::FIXED )
		*/
		void setFontStyle(int style);
	};
}

#endif // _GRAPHICS_H_INCLUDED_
