/*
Copyright (c) 2004 Tino
Copyright (c) 2005 bayside

Permission is hereby granted, free of charge, to any person 
obtaining a copy of this software and associated documentation files 
(the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, 
publish, distribute, sublicense, and/or sell copies of the Software, 
and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:

The above copyright notice and this permission notice shall be 
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#if !defined(_POINTER_H_INCLUDED_)
#define _POINTER_H_INCLUDED_

namespace baygui {
	#define _P baygui::Pointer

	/** QƃJEg^X}[g|C^[ */
	template <class T> struct Pointer {
	private:
		/** |C^[ */
		T* pointer;
		/** QƃJEg */
		int* refCount;

	private:
		/**  */
		inline void Initialize()
		{
			this->pointer = 0 /* NULL */;
			this->refCount = 0 /* NULL */;
		}

	public:
		/** ftHgRXgN^ */
		Pointer()
		{
			this->Initialize();
		}
		
		/** Rs[RXgN^ */
		Pointer(Object* pointer)
		{
			this->Initialize();
			this->set(pointer);
		}
		
		/** fXgN^ */
		~Pointer()
		{
			this->unset();
		}
		
		/** IuWFNgݒ肷 */
		void set(Object* pointer)
		{
			this->unset();
			this->pointer = (T*)pointer;
			if (this->pointer == 0 /* NULL */) return;
			this->refCount = pointer->getPointer();
			(*this->refCount)++;
		}
		
		/** IuWFNgj */
		void unset()
		{
			if (this->refCount != 0 /* NULL */) {
				(*this->refCount)--;
				if (*this->refCount < 1) {
					this->refCount = 0 /*NULL*/;
					delete this->pointer;
				} else {
					this->refCount = 0 /*NULL*/;
				}
				this->pointer = 0 /* NULL */;
			}
		}
		
		/** A[Zq̑d` */
		inline T* operator ->()
		{
			return this->pointer;
		}
		
		/** |C^[𓾂 */
		inline T* get()
		{
			return this->pointer;
		}
		
		/** QƃJEg𓾂 */
		inline int getRefCount() const
		{
			return this->refCount != 0 ? *this->refCount : -1;
		}
		
		/** ==Zq̑d` */
		inline bool operator ==(T* arg) const
		{
			return this->pointer == arg;
		}
		
		/** !=Zq̑d` */
		inline bool operator !=(T* arg) const
		{
			return this->pointer != arg;
		}
		
		/** ==Zq̑d` */
		inline bool operator ==(const Pointer<T>& arg) const
		{
			return this->pointer == arg.pointer;
		}
		
		/** !=Zq̑d` */
		inline bool operator !=(const Pointer<T>& arg) const
		{
			return this->pointer != arg.pointer;
		}
		
		/** Zq̑d` */
		inline Pointer<T>& operator =(Object* pointer)
		{
			this->set(pointer);
			return *this;
		}
	};
}

#endif // _POINTER_H_INCLUDED_
