/*
 * MonaJsonRPCClient.java
 *
 * Copyright 2014 the Monache.org.
 * http://www.monache.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.monache.nagesen.jsonrpc;

import java.nio.charset.Charset;

import org.monache.lib.api.CoinAPIJsonRPCClient;
import org.monache.lib.httpclient.HttpClient;
import org.monache.lib.jsonrpc.JsonRPCException;
import org.seasar.framework.container.annotation.tiger.Binding;

/**
 * 
 * 
 * @author monache.org
 * @since 1.0
 */
public class MonaJsonRPCClient extends CoinAPIJsonRPCClient {

	/**
	 * @throws JsonRPCException
	 * @since 1.0
	 */
	public MonaJsonRPCClient() throws JsonRPCException {
	}

	/**
	 * @param httpClient
	 * @throws JsonRPCException
	 * @since 1.0
	 */
	public MonaJsonRPCClient(HttpClient httpClient) throws JsonRPCException {
		super(httpClient);
	}

	/**
	 * @param httpClient
	 * @param uri
	 * @param schema
	 * @param responseCharset
	 * @throws JsonRPCException
	 * @since 1.0
	 */
	public MonaJsonRPCClient(HttpClient httpClient, String uri, String schema,
			Charset responseCharset) throws JsonRPCException {
		super(httpClient, uri, schema, responseCharset);
	}

	@Binding("MonaHttpClient")
	public void setHttpClient(HttpClient httpClient) {
		super.setHttpClient(httpClient);
	}

}
