/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.WebResponse;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

class ByteTag {
    private String _name = "";
    private Hashtable _attributes;
    private char[] _buffer;
    private int _start;
    private int _end = -1;

    ByteTag(byte[] buffer, int start, int length) throws UnsupportedEncodingException {
        this._buffer = new String(buffer, start, length, WebResponse.getDefaultEncoding()).toCharArray();
        this._name = this.nextToken();
        String attribute = "";
        String token = this.nextToken();
        while (token.length() != 0) {
            if (token.equals("=") && attribute.length() != 0) {
                this.getAttributes().put(attribute.toLowerCase(), this.nextToken());
                attribute = "";
            } else {
                if (attribute.length() > 0) {
                    this.getAttributes().put(attribute.toLowerCase(), "");
                }
                attribute = token;
            }
            token = this.nextToken();
        }
    }

    public String getName() {
        return this._name;
    }

    public String getAttribute(String attributeName) {
        return (String)this.getAttributes().get(attributeName);
    }

    public String toString() {
        return "ByteTag[ name=" + this._name + ";attributes = " + this._attributes + ']';
    }

    private Hashtable getAttributes() {
        if (this._attributes == null) {
            this._attributes = new Hashtable();
        }
        return this._attributes;
    }

    private String nextToken() {
        this._start = this._end + 1;
        while (this._start < this._buffer.length && Character.isWhitespace(this._buffer[this._start])) {
            ++this._start;
        }
        if (this._start >= this._buffer.length) {
            return "";
        }
        if (this._buffer[this._start] == '\"') {
            this._end = this._start + 1;
            while (this._end < this._buffer.length && this._buffer[this._end] != '\"') {
                ++this._end;
            }
            return new String(this._buffer, this._start + 1, this._end - this._start - 1);
        }
        if (this._buffer[this._start] == '\'') {
            this._end = this._start + 1;
            while (this._end < this._buffer.length && this._buffer[this._end] != '\'') {
                ++this._end;
            }
            return new String(this._buffer, this._start + 1, this._end - this._start - 1);
        }
        if (this._buffer[this._start] == '=') {
            this._end = this._start;
            return "=";
        }
        this._end = this._start + 1;
        while (this._end < this._buffer.length && this._buffer[this._end] != '=' && !Character.isWhitespace(this._buffer[this._end])) {
            ++this._end;
        }
        return new String(this._buffer, this._start, this._end-- - this._start);
    }
}

