/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HtmlErrorListener;
import java.util.Vector;

public abstract class HttpUnitOptions {
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static boolean _acceptGzip = true;
    private static boolean _parserWarningsEnabled;
    private static boolean _exceptionsOnErrorStatus;
    private static boolean _parameterValuesValidated;
    private static boolean _imagesTreatedAsAltText;
    private static boolean _loggingHttpHeaders;
    private static boolean _matchesIgnoreCase;
    private static boolean _autoRefresh;
    private static boolean _autoRedirect;
    private static boolean _postIncludesCharset;
    private static boolean _checkContentLength;
    private static int _redirectDelay;
    private static String _characterSet;
    private static String _contentType;
    private static Vector _listeners;

    static {
        _exceptionsOnErrorStatus = true;
        _parameterValuesValidated = true;
        _matchesIgnoreCase = true;
        _autoRedirect = true;
        _postIncludesCharset = false;
        _checkContentLength = false;
        _characterSet = "iso-8859-1";
        _contentType = DEFAULT_CONTENT_TYPE;
        _listeners = new Vector();
    }

    public static void reset() {
        _parserWarningsEnabled = false;
        _exceptionsOnErrorStatus = true;
        _parameterValuesValidated = true;
        _imagesTreatedAsAltText = false;
        _loggingHttpHeaders = false;
        _matchesIgnoreCase = true;
        _autoRefresh = false;
        _autoRedirect = true;
        _checkContentLength = false;
        _redirectDelay = 0;
        _characterSet = "iso-8859-1";
        _contentType = DEFAULT_CONTENT_TYPE;
        _postIncludesCharset = false;
        _acceptGzip = true;
    }

    public static boolean isAcceptGzip() {
        return _acceptGzip;
    }

    public static void setAcceptGzip(boolean acceptGzip) {
        _acceptGzip = acceptGzip;
    }

    public static void resetDefaultCharacterSet() {
        _characterSet = "iso-8859-1";
    }

    public static void resetDefaultContentType() {
        _contentType = DEFAULT_CONTENT_TYPE;
    }

    public static void setDefaultCharacterSet(String characterSet) {
        _characterSet = characterSet;
    }

    public static String getDefaultCharacterSet() {
        return _characterSet;
    }

    public static boolean isCheckContentLength() {
        return _checkContentLength;
    }

    public static void setCheckContentLength(boolean checkContentLength) {
        _checkContentLength = checkContentLength;
    }

    public static void setPostIncludesCharset(boolean postIncludesCharset) {
        _postIncludesCharset = postIncludesCharset;
    }

    public static boolean isPostIncludesCharset() {
        return _postIncludesCharset;
    }

    public static void setDefaultContentType(String contentType) {
        _contentType = contentType;
    }

    public static String getDefaultContentType() {
        return _contentType;
    }

    public static boolean getParserWarningsEnabled() {
        return _parserWarningsEnabled;
    }

    public static void setExceptionsThrownOnErrorStatus(boolean enabled) {
        _exceptionsOnErrorStatus = enabled;
    }

    public static boolean getExceptionsThrownOnErrorStatus() {
        return _exceptionsOnErrorStatus;
    }

    public static void setParserWarningsEnabled(boolean enabled) {
        _parserWarningsEnabled = enabled;
    }

    public static boolean getParameterValuesValidated() {
        return _parameterValuesValidated;
    }

    public static void setParameterValuesValidated(boolean validated) {
        _parameterValuesValidated = validated;
    }

    public static boolean getImagesTreatedAsAltText() {
        return _imagesTreatedAsAltText;
    }

    public static void setImagesTreatedAsAltText(boolean asText) {
        _imagesTreatedAsAltText = asText;
    }

    public static boolean getMatchesIgnoreCase() {
        return _matchesIgnoreCase;
    }

    public static void setMatchesIgnoreCase(boolean ignoreCase) {
        _matchesIgnoreCase = ignoreCase;
    }

    public static boolean isLoggingHttpHeaders() {
        return _loggingHttpHeaders;
    }

    public static void setLoggingHttpHeaders(boolean enabled) {
        _loggingHttpHeaders = enabled;
    }

    public static boolean getAutoRedirect() {
        return _autoRedirect;
    }

    public static void setAutoRedirect(boolean autoRedirect) {
        _autoRedirect = autoRedirect;
    }

    public static int getRedirectDelay() {
        return _redirectDelay;
    }

    public static void setRedirectDelay(int delayInMilliseconds) {
        _redirectDelay = delayInMilliseconds;
    }

    public static boolean getAutoRefresh() {
        return _autoRefresh;
    }

    public static void setAutoRefresh(boolean autoRefresh) {
        _autoRefresh = autoRefresh;
    }

    public static void removeHtmlErrorListener(HtmlErrorListener el) {
        _listeners.removeElement(el);
    }

    public static void addHtmlErrorListener(HtmlErrorListener el) {
        _listeners.addElement(el);
    }

    public static Vector getHtmlErrorListeners() {
        return _listeners;
    }
}

