/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLSegment;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParsedHTML;
import java.net.URL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableCell
extends ParsedHTML
implements HTMLSegment {
    private Element _element;
    private int _colSpan;
    private int _rowSpan;

    public int getColSpan() {
        return this._colSpan;
    }

    public int getRowSpan() {
        return this._rowSpan;
    }

    public String asText() {
        return this.getCellContentsAsText(this._element);
    }

    public Node getDOM() {
        return super.getDOM();
    }

    TableCell(Element cellNode, URL url, String parentTarget, String characterSet) {
        super(url, parentTarget, cellNode, characterSet);
        this._element = cellNode;
        this._colSpan = this.getAttributeValue(cellNode, "colspan", 1);
        this._rowSpan = this.getAttributeValue(cellNode, "rowspan", 1);
    }

    private String getCellContentsAsText(Node node) {
        if (node == null) {
            return "";
        }
        if (!node.hasChildNodes()) {
            return "";
        }
        return NodeUtils.asText(node.getChildNodes());
    }

    private int getAttributeValue(Node node, String attributeName, int defaultValue) {
        return NodeUtils.getAttributeValue(node, attributeName, defaultValue);
    }
}

