/*
 * Decompiled with CFR 0.152.
 */
package monalipse.server.giko;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpException;
import com.meterware.httpunit.IURLConnectionListener;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import monalipse.MonalipsePlugin;
import monalipse.server.BBSServerManager;
import monalipse.server.IBBSBoard;
import monalipse.server.ILinkedLineFragment;
import monalipse.server.INewResponseLineFragment;
import monalipse.server.IResponseEnumeration;
import monalipse.server.IResponseHeaderLine;
import monalipse.server.IThreadContentProvider;
import monalipse.server.giko.GikoServer;
import monalipse.utils.CancelableRunner;
import monalipse.views.IBBSReference;
import monalipse.widgets.ColoredText;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.xml.sax.SAXException;

class ThreadContentProvider
implements IAdaptable,
IThreadContentProvider,
IBBSReference {
    private IBBSBoard board;
    private String urlHint = "";
    private String id;
    private int index;
    private String name;
    private int responses;
    private int cachedResponses = -1;
    private static final PatternAction NUM_REF_PATTERN = new PatternAction(Pattern.compile("(>|\uff1e)+(([0-9\uff10-\uff19]+)(->*([0-9\uff10-\uff19]+))?)")){

        public String getLink(String urlBase, Matcher m) {
            String start = ThreadContentProvider.toASCIIDigits(m.group(3));
            String end = m.group(5);
            end = end == null ? start : ThreadContentProvider.toASCIIDigits(end);
            return String.valueOf(urlBase) + start + "-" + end;
        }
    };
    private static final PatternAction NAME_NUM_REF_PATTERN = new PatternAction(Pattern.compile("[0-9\uff10-\uff19]+")){

        public String getLink(String urlBase, Matcher m) {
            String num = ThreadContentProvider.toASCIIDigits(m.group());
            return String.valueOf(urlBase) + num + "-" + num;
        }

        public boolean next(Matcher m) {
            return m.matches();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction TRIP_DECL_PATTERN = new PatternAction(Pattern.compile("\u25c6([\\p{Alnum}\\./]{8,10})")){

        public String getLink(String urlBase, Matcher m) {
            return "trip:" + m.group(1);
        }

        public boolean next(Matcher m) {
            return m.find();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction URL_REF_PATTERN = new PatternAction(Pattern.compile("(((h?t)?t)?p)?(s?://[\\p{Alnum}\\.\\-_:]+(/[\\p{Alnum}!#%&'*+,-./:;=?@\\\\^_`\\|~]*)?)")){

        public String getLink(String urlBase, Matcher m) {
            return "http" + m.group(4);
        }
    };
    private static final PatternAction ID_DECL_PATTERN = new PatternAction(Pattern.compile("ID:(.{8})")){

        public String getLink(String urlBase, Matcher m) {
            return "id:" + m.group(1).trim();
        }

        public boolean isLink() {
            return false;
        }
    };
    private static final PatternAction[] NAME_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN, NAME_NUM_REF_PATTERN, TRIP_DECL_PATTERN};
    private static final PatternAction[] MAIL_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN};
    private static final PatternAction[] DATE_PATTERN_SET = new PatternAction[]{ID_DECL_PATTERN};
    private static final PatternAction[] BODY_PATTERN_SET = new PatternAction[]{NUM_REF_PATTERN, URL_REF_PATTERN};
    static /* synthetic */ Class class$0;

    public ThreadContentProvider(IBBSBoard board, String id, int index, String name, int responses) {
        this.board = board;
        this.id = id;
        this.index = index;
        this.name = name;
        this.responses = responses;
        String baseURL = board.getURL().toExternalForm();
        int ss = baseURL.indexOf("//");
        if (ss != -1 && id.endsWith(".dat")) {
            int s = baseURL.indexOf(47, ss + 2);
            this.urlHint = String.valueOf(baseURL.substring(0, s)) + "/test/read.cgi" + baseURL.substring(s, baseURL.length()) + id.substring(0, id.length() - 4) + "/";
        }
    }

    public URL getURL() {
        try {
            return new URL(String.valueOf(this.urlHint) + "l50");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public IFolder getLogFolder() {
        return this.board.getLogFolder();
    }

    public IFile getLogFile() {
        return this.getLogFolder().getFile(this.id);
    }

    public IBBSBoard getBoard() {
        return this.board;
    }

    public String getID() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getResponses((List)null, 0, 0);
        }
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public int getResponseCountHint() {
        return this.responses;
    }

    public boolean hasNewResponses() {
        return this.getCachedCount() > 0 && this.getCachedCount() < this.getResponseCountHint();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ThreadContentProvider) {
            ThreadContentProvider thread = (ThreadContentProvider)obj;
            return thread.getLogFolder().equals((Object)this.getLogFolder()) && thread.getID().equals(this.getID());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean submitResponse(CancelableRunner.ICancelableProgressMonitor monitor, String name, String mail, String body) {
        block21: {
            String l;
            BufferedReader r;
            WebResponse resp;
            URLConnectionListener conn;
            boolean retry;
            PostMethodWebRequest req;
            WebConversation wc;
            monitor.beginTask("submitting...", 6);
            try {
                try {
                    monitor.worked(1);
                    monitor.subTask("POST");
                    wc = GikoServer.getWebConversation();
                    wc.addCookie("NAME", name);
                    wc.addCookie("MAIL", mail);
                    req = new PostMethodWebRequest(new URL(this.getURL(), "/test/bbs.cgi").toExternalForm());
                    req.setHeaderField("Referer", this.getURL().toExternalForm());
                    String bbs = this.board.getURL().getFile();
                    req.setParameter("submit", "\u66f8\u304d\u8fbc\u3080");
                    req.setParameter("bbs", bbs.substring(1, bbs.length() - 1));
                    req.setParameter("key", this.id.substring(0, this.id.lastIndexOf(46)));
                    req.setParameter("time", String.valueOf(System.currentTimeMillis() / 1000L));
                    req.setParameter("FROM", name);
                    req.setParameter("mail", mail);
                    req.setParameter("MESSAGE", body);
                    String sid = GikoServer.getOysterSessionID(monitor.getRunner().getSubProgressMonitor(monitor, 2));
                    if (sid != null) {
                        req.setParameter("sid", sid);
                    }
                    monitor.subTask("retry POST with sid");
                    retry = false;
                    conn = new URLConnectionListener(monitor.getRunner());
                    try {
                        resp = wc.getResponse(req, conn);
                        r = new BufferedReader(new InputStreamReader(resp.getInputStream(), "Windows-31J"));
                        monitor.worked(1);
                        try {}
                        catch (Throwable throwable) {
                            Object var14_15 = null;
                            r.close();
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_18 = null;
                        conn.close();
                        throw throwable;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    break block21;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    break block21;
                }
                catch (IOException iOException) {
                    break block21;
                }
                catch (SAXException sAXException) {
                    break block21;
                }
            }
            catch (Throwable throwable) {
                Object var18_22 = null;
                monitor.done();
                throw throwable;
            }
            while ((l = r.readLine()) != null) {
                if (l.indexOf("\u66f8\u304d\u3053\u307f\u307e\u3057\u305f") != -1) {
                    Object var14_14 = null;
                    r.close();
                    Object var16_17 = null;
                    conn.close();
                    Object var18_20 = null;
                    monitor.done();
                    return true;
                }
                if (l.indexOf("\u78ba\u8a8d") == -1) continue;
                retry = true;
            }
            Object var14_16 = null;
            r.close();
            Object var16_19 = null;
            conn.close();
            if (retry) {
                try {
                    resp = wc.getResponse(req, conn);
                    r = new BufferedReader(new InputStreamReader(resp.getInputStream(), "Windows-31J"));
                    monitor.worked(1);
                    try {}
                    catch (Throwable throwable) {
                        var14_16 = null;
                        r.close();
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    var16_19 = null;
                    conn.close();
                    throw throwable;
                }
                while ((l = r.readLine()) != null) {
                    if (l.indexOf("\u66f8\u304d\u3053\u307f\u307e\u3057\u305f") == -1) continue;
                    var14_16 = null;
                    r.close();
                    var16_19 = null;
                    conn.close();
                    Object var18_21 = null;
                    monitor.done();
                    return true;
                }
                var14_16 = null;
                r.close();
                var16_19 = null;
                conn.close();
            }
        }
        Object var18_23 = null;
        monitor.done();
        return false;
    }

    public IResponseEnumeration getResponses(CancelableRunner.ICancelableProgressMonitor monitor, int sequence, int rangeStart) {
        LogFile log;
        block9: {
            log = null;
            try {
                boolean partial;
                IFile file = this.getLogFile();
                MonalipsePlugin.ensureSynchronized(file);
                if (!file.exists() || (log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())))) == null) break block9;
                boolean bl = partial = log.sequence == sequence;
                if (partial) {
                    try {
                        if (log.responseCount < rangeStart) {
                            throw new IOException();
                        }
                        int i = 0;
                        while (i < rangeStart) {
                            log.skipResponse();
                            ++i;
                        }
                    }
                    catch (IOException iOException) {
                        log.close();
                        log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                        return new ThreadLogReader(monitor, log.title, log, false, log.sequence, log.isActive);
                    }
                }
                return new ThreadLogReader(monitor, log.title, log, partial, log.sequence, log.isActive);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (log != null) {
            log.close();
        }
        return new NullResponseEnumeration(this.getURL().toExternalForm(), sequence);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getResponses(List lineReceiver, int start, int end) {
        LogFile log = null;
        String title = null;
        try {
            try {
                IFile file = this.getLogFile();
                MonalipsePlugin.ensureSynchronized(file);
                if (file.exists() && (log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())))) != null) {
                    title = log.title;
                    int i = 1;
                    while (i < start && i < log.responseCount + 1) {
                        log.skipResponse();
                        ++i;
                    }
                    i = start;
                    while (i <= end && i < log.responseCount + 1) {
                        log.readResponse(lineReceiver);
                        ++i;
                    }
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (log == null) throw throwable;
            log.close();
            throw throwable;
        }
        Object var8_12 = null;
        if (log == null) return title;
        log.close();
        return title;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResponseEnumeration updateResponses(CancelableRunner.ICancelableProgressMonitor monitor, IWorkbenchWindow workbenchWindow, int sequence, int rangeStart) {
        IResponseEnumeration res;
        boolean notFound;
        String title;
        int remining;
        String lastModified;
        IFile file;
        GetMethodWebRequest req;
        block27: {
            WebConversation wc = GikoServer.getWebConversation();
            req = new GetMethodWebRequest(this.board.getURL(), "dat/" + this.id);
            file = this.getLogFile();
            lastModified = null;
            remining = 100;
            monitor.beginTask("downloading...", remining);
            title = this.getURL().toExternalForm();
            notFound = false;
            System.err.println("partial");
            try {
                LogFile log;
                block28: {
                    ArrayThreadReader arrayThreadReader;
                    block32: {
                        MonalipsePlugin.ensureSynchronized(file);
                        if (!file.exists()) break block27;
                        log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                        try {
                            URLConnectionListener conn;
                            block30: {
                                block31: {
                                    ThreadDownloader threadDownloader;
                                    block29: {
                                        boolean partial;
                                        if (log == null) break block28;
                                        title = log.title;
                                        lastModified = log.lastModifierd;
                                        boolean bl = partial = log.sequence == sequence;
                                        if (!partial) break block28;
                                        ArrayList logs = new ArrayList();
                                        ArrayList lastResponse = null;
                                        if (rangeStart <= log.responseCount) {
                                            while (log.available()) {
                                                lastResponse = new ArrayList();
                                                log.readResponse(lastResponse);
                                                logs.add(lastResponse);
                                            }
                                        }
                                        if (lastResponse == null) break block28;
                                        req.setHeaderField("Range", "bytes=" + log.httpRangeStart + "-");
                                        req.setHeaderField("If-Modified-Since", lastModified);
                                        remining -= 10;
                                        monitor.worked(10);
                                        monitor.subTask("GET " + req.getURL());
                                        conn = new URLConnectionListener(monitor.getRunner());
                                        try {
                                            WebResponse wr = wc.getResponse(req, conn);
                                            if (wr.getResponseCode() == 206) {
                                                RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(log.httpRangeStart, wr.getInputStream());
                                                InputStreamReader r = new InputStreamReader((InputStream)cin, "Windows-31J");
                                                int contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
                                                ArrayList lineReceiver = new ArrayList();
                                                LogFile.parseResponse(r, lineReceiver, logs.size(), this.urlHint);
                                                if (this.equalResponse(lastResponse, lineReceiver)) {
                                                    ThreadDownloader e = new ThreadDownloader(monitor.getRunner().getSubProgressMonitor(monitor, remining), workbenchWindow, log.title, conn, r, cin, true, log.sequence, wr.getHeaderField("Last-Modified"), logs, rangeStart, contentLength, file, true);
                                                    conn = null;
                                                    threadDownloader = e;
                                                    Object var23_31 = null;
                                                    if (conn != null) {
                                                        conn.close();
                                                    }
                                                    break block29;
                                                }
                                                r.close();
                                                break block30;
                                            }
                                            if (wr.getResponseCode() == 304) {
                                                wr.getInputStream().close();
                                                arrayThreadReader = new ArrayThreadReader(log.title, true, log.sequence, logs, rangeStart, true);
                                                break block31;
                                            }
                                            if (wr.getResponseCode() != 404 && wr.getResponseCode() != 302) break block30;
                                            notFound = true;
                                            break block30;
                                        }
                                        catch (Throwable throwable) {
                                            Object var23_33 = null;
                                            if (conn == null) throw throwable;
                                            conn.close();
                                            throw throwable;
                                        }
                                    }
                                    Object var26_35 = null;
                                    if (log == null) return threadDownloader;
                                    log.close();
                                    return threadDownloader;
                                }
                                Object var23_32 = null;
                                if (conn != null) {
                                    conn.close();
                                }
                                break block32;
                            }
                            Object var23_34 = null;
                            if (conn != null) {
                                conn.close();
                            }
                            break block28;
                        }
                        catch (Throwable throwable) {
                            Object var26_37 = null;
                            if (log == null) throw throwable;
                            log.close();
                            throw throwable;
                        }
                    }
                    Object var26_36 = null;
                    if (log == null) return arrayThreadReader;
                    log.close();
                    return arrayThreadReader;
                }
                Object var26_38 = null;
                if (log != null) {
                    log.close();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (HttpException e) {
                e.printStackTrace();
            }
        }
        ++sequence;
        System.err.println("full");
        if (!notFound) {
            monitor.worked(10);
            req.removeHeaderField("Range");
            res = this.getResponse(req, lastModified, monitor.getRunner().getSubProgressMonitor(monitor, remining -= 10), workbenchWindow, title, sequence, file, false, true);
            if (res != null) {
                return res;
            }
        }
        req = 14 <= this.id.length() ? new GetMethodWebRequest(this.board.getURL(), "kako/" + this.id.substring(0, 4) + "/" + this.id.substring(0, 5) + "/" + this.id + ".gz") : (this.id.length() == 13 ? new GetMethodWebRequest(this.board.getURL(), "kako/" + this.id.substring(0, 3) + "/" + this.id + ".gz") : null);
        System.err.println("log " + req);
        if (req != null) {
            remining -= 10;
            monitor.worked(10);
            try {
                monitor.subTask("GET " + req.getURL());
            }
            catch (MalformedURLException malformedURLException) {}
            res = this.getResponse(req, lastModified, monitor.getRunner().getSubProgressMonitor(monitor, remining), workbenchWindow, title, sequence, file, false, false);
            if (res != null) {
                return res;
            }
        }
        System.err.println("oyster ");
        String sid = GikoServer.getOysterSessionID(monitor.getRunner().getSubProgressMonitor(monitor, 10));
        remining -= 10;
        if (sid == null) return new NullResponseEnumeration(title, sequence);
        try {
            req = new GetMethodWebRequest(this.getURL(), "/test/offlaw.cgi");
            String bbs = this.board.getURL().getFile();
            req.setParameter("bbs", bbs.substring(1, bbs.length() - 1));
            req.setParameter("key", this.id.substring(0, this.id.lastIndexOf(46)));
            req.setParameter("sid", sid);
            req.setParameter("raw", "0.0");
            monitor.worked(10);
            monitor.subTask("GET " + req.getURL());
            IResponseEnumeration res2 = this.getResponse(req, lastModified, monitor.getRunner().getSubProgressMonitor(monitor, remining -= 10), workbenchWindow, title, sequence, file, true, false);
            if (res2 == null) return new NullResponseEnumeration(title, sequence);
            return res2;
        }
        catch (MalformedURLException malformedURLException) {}
        return new NullResponseEnumeration(title, sequence);
    }

    private boolean equalResponse(List resp1, List resp2) {
        if (resp1.size() != resp2.size()) {
            return false;
        }
        int i = 0;
        while (i < resp1.size()) {
            ColoredText.Line line1 = (ColoredText.Line)resp1.get(i);
            ColoredText.Line line2 = (ColoredText.Line)resp2.get(i);
            if (line1.getLineFragmentCount() != line2.getLineFragmentCount()) {
                return false;
            }
            int j = 0;
            while (j < line1.getLineFragmentCount()) {
                ColoredText.LineFragment frag1 = line1.getLineFragmentAt(j);
                ColoredText.LineFragment frag2 = line2.getLineFragmentAt(j);
                if (!frag1.getText().equals(frag2.getText())) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IResponseEnumeration getResponse(WebRequest req, String lastModified, CancelableRunner.ICancelableProgressMonitor monitor, IWorkbenchWindow workbenchWindow, String title, int sequence, IFile file, boolean oyster, boolean active) {
        try {
            URLConnectionListener conn;
            block12: {
                NullResponseEnumeration nullResponseEnumeration;
                if (lastModified != null) {
                    req.setHeaderField("If-Modified-Since", lastModified);
                }
                conn = new URLConnectionListener(monitor.getRunner());
                try {
                    WebResponse wr = GikoServer.getWebConversation().getResponse(req, conn);
                    if (wr.getResponseCode() == 200) {
                        RangeAnalyzeInputStream cin = new RangeAnalyzeInputStream(0, wr.getInputStream());
                        InputStreamReader r = new InputStreamReader((InputStream)cin, "Windows-31J");
                        int contentLength = 0;
                        String enc = wr.getHeaderField("Content-Encoding");
                        String len = wr.getHeaderField("Content-Length");
                        if (enc != null && enc.equals("gzip") && oyster) {
                            contentLength = this.readContentLength(r);
                        } else if (len != null) {
                            contentLength = Integer.parseInt(wr.getHeaderField("Content-Length"));
                        }
                        ThreadDownloader e = new ThreadDownloader(monitor, workbenchWindow, title, conn, r, cin, false, sequence, wr.getHeaderField("Last-Modified"), new ArrayList(), 0, contentLength, file, active);
                        conn = null;
                        ThreadDownloader threadDownloader = e;
                        Object var18_24 = null;
                        if (conn == null) return threadDownloader;
                        conn.close();
                        return threadDownloader;
                    }
                    if (wr.getResponseCode() != 304) break block12;
                    wr.getInputStream().close();
                    nullResponseEnumeration = new NullResponseEnumeration(this.getURL().toExternalForm(), sequence);
                }
                catch (Throwable throwable) {
                    Object var18_26 = null;
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                Object var18_25 = null;
                if (conn == null) return nullResponseEnumeration;
                conn.close();
                return nullResponseEnumeration;
            }
            Object var18_27 = null;
            if (conn == null) return null;
            conn.close();
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        return null;
    }

    private int readContentLength(InputStreamReader r) throws IOException {
        if (r.read() != 43 || r.read() != 79 || r.read() != 75 || r.read() != 32) {
            throw new IOException();
        }
        int ch = r.read();
        StringBuffer buf = new StringBuffer();
        while (ch != 47) {
            buf.append((char)ch);
            ch = r.read();
        }
        ch = r.read();
        while (ch != 47) {
            ch = r.read();
        }
        r.read();
        return Integer.parseInt(buf.toString());
    }

    public int getCachedCount() {
        block18: {
            if (this.cachedResponses == -1) {
                this.cachedResponses = 0;
                try {
                    String cached;
                    IFolder iFolder = this.getLogFolder();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("monalipse.editors.ThreadViewerEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((cached = iFolder.getPersistentProperty(new QualifiedName(clazz.getName(), String.valueOf(this.getID()) + ".cached"))) != null) {
                        this.cachedResponses = Integer.parseInt(cached);
                    }
                }
                catch (CoreException coreException) {
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    IFile file = this.getLogFile();
                    if (!file.exists()) break block18;
                    LogFile log = LogFile.of(new DataInputStream(new BufferedInputStream(file.getContents())));
                    try {
                        if (log != null) {
                            this.cachedResponses = log.responseCount;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        if (log != null) {
                            log.close();
                        }
                        throw throwable;
                    }
                    Object var3_5 = null;
                    if (log != null) {
                        log.close();
                    }
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
        }
        return this.cachedResponses;
    }

    public void prefetchToolTip(ColoredText.ToolTipTarget target) {
        if (target instanceof HoverLineFragment) {
            ((HoverLineFragment)target).prefetchToolTip();
        }
    }

    public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, ColoredText.ToolTipTarget target, String sourceTitle) {
        if (target instanceof HoverLineFragment) {
            return ((HoverLineFragment)target).fillToolTip(parent, sourceText, maxWidth, sourceTitle);
        }
        return new Point(0, 0);
    }

    public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection, String sourceTitle) {
        return HoverLineFragment.fillToolTip(parent, sourceText, maxWidth, selection, sourceTitle);
    }

    private static String toASCIIDigits(String str) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if ('\uff10' <= ch && ch <= '\uff19') {
                ch = (char)(48 + (ch - 65296));
            }
            buf.append(ch);
            ++i;
        }
        return buf.toString();
    }

    static /* synthetic */ IBBSBoard access$2(ThreadContentProvider threadContentProvider) {
        return threadContentProvider.board;
    }

    private class ThreadDownloader
    implements IResponseEnumeration,
    CancelableRunner.ICancelableRunnableWithProgress {
        private CancelableRunner.ICancelableProgressMonitor monitor;
        private IWorkbenchWindow workbenchWindow;
        private String title;
        private Reader r;
        private RangeAnalyzeInputStream cin;
        private boolean partial;
        private int sequence;
        private String lastModified;
        private List log;
        private IFile logFile;
        private int position;
        private int contentRange;
        private int contentLength;
        private boolean closed;
        private boolean active;
        private URLConnectionListener connection;
        private boolean getLog;

        public ThreadDownloader(CancelableRunner.ICancelableProgressMonitor monitor, IWorkbenchWindow workbenchWindow, String title, URLConnectionListener connection, Reader r, RangeAnalyzeInputStream cin, boolean partial, int sequence, String lastModified, List log, int position, int contentLength, IFile logFile, boolean active) {
            this.monitor = monitor;
            this.workbenchWindow = workbenchWindow;
            this.title = title;
            this.connection = connection;
            this.r = r;
            this.cin = cin;
            this.partial = partial;
            this.sequence = sequence;
            this.lastModified = lastModified;
            this.log = log;
            this.position = position;
            this.contentLength = contentLength;
            this.logFile = logFile;
            this.active = active;
            this.contentRange = cin.getRange();
            monitor.getRunner().run(null, this);
        }

        public void run(CancelableRunner.ICancelableProgressMonitor mon) {
            try {
                try {
                    this.monitor.beginTask("", 100);
                    int worked = 0;
                    while (!mon.isCanceled()) {
                        ArrayList lines = new ArrayList();
                        String title = LogFile.parseResponse(this.r, lines, this.log.size() + 1, ThreadContentProvider.this.urlHint);
                        if (lines.size() == 0) break;
                        this.getLog = true;
                        this.log.add(lines);
                        if (this.log.size() == 1 && title != null) {
                            this.title = title;
                        }
                        ThreadDownloader threadDownloader = this;
                        synchronized (threadDownloader) {
                            this.notifyAll();
                        }
                        Thread.yield();
                        int w = this.contentLength == 0 ? 100 : Math.min((this.cin.getRange() - this.contentRange) * 100 / this.contentLength, 100);
                        if (worked != w) {
                            this.monitor.worked(w - worked);
                        }
                        worked = w;
                    }
                    this.monitor.done();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                ThreadDownloader threadDownloader = this;
                synchronized (threadDownloader) {
                    this.closed = true;
                    this.notifyAll();
                    try {
                        this.r.close();
                    }
                    catch (IOException iOException) {}
                    this.connection.close();
                }
                throw throwable;
            }
            Object var6_9 = null;
            ThreadDownloader threadDownloader = this;
            synchronized (threadDownloader) {
                this.closed = true;
                this.notifyAll();
                try {
                    this.r.close();
                }
                catch (IOException iOException) {}
                this.connection.close();
            }
        }

        private void setLog(int pos) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            LogFile.writeLogFile(dout, this.sequence, this.title, this.lastModified, this.active, pos, this.log);
            dout.close();
            byte[] bytes = bout.toByteArray();
            MonalipsePlugin.asyncExec(this.workbenchWindow, (IRunnableWithProgress)new WorkspaceModifyOperation(this, bytes){
                private final /* synthetic */ ThreadDownloader this$1;
                private final /* synthetic */ byte[] val$bytes;
                {
                    this.this$1 = threadDownloader;
                    this.val$bytes = byArray;
                }

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ThreadContentProvider.access$2(ThreadDownloader.access$1(this.this$1)).createLogFolder(ThreadDownloader.access$0(this.this$1), monitor);
                        IFile cache = ThreadDownloader.access$1(this.this$1).getLogFile();
                        MonalipsePlugin.ensureSynchronized(cache);
                        if (cache.exists()) {
                            cache.setContents((InputStream)new ByteArrayInputStream(this.val$bytes), false, false, monitor);
                        } else {
                            cache.create((InputStream)new ByteArrayInputStream(this.val$bytes), false, monitor);
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return !this.closed && this.position < this.log.size();
        }

        public boolean hasNextResponse() {
            return !this.closed || this.position < this.log.size();
        }

        public boolean getNextResponse(List lineReceiver) throws InterruptedException {
            ThreadDownloader threadDownloader = this;
            synchronized (threadDownloader) {
                while (!this.closed && this.position == this.log.size()) {
                    this.wait();
                }
            }
            if (this.position < this.log.size()) {
                lineReceiver.addAll((Collection)this.log.get(this.position++));
                return true;
            }
            return false;
        }

        public void close() {
            try {
                if (this.getLog) {
                    ThreadContentProvider.this.cachedResponses = this.log.size();
                    this.setLog(this.cin.getRange());
                }
            }
            catch (IOException iOException) {}
        }

        public boolean isWritable() {
            return this.active;
        }

        static /* synthetic */ IWorkbenchWindow access$0(ThreadDownloader threadDownloader) {
            return threadDownloader.workbenchWindow;
        }

        static /* synthetic */ ThreadContentProvider access$1(ThreadDownloader threadDownloader) {
            return threadDownloader.ThreadContentProvider.this;
        }
    }

    private class ArrayThreadReader
    implements IResponseEnumeration {
        private String title;
        private boolean partial;
        private int sequence;
        private List log;
        private int position;
        private boolean active;

        public ArrayThreadReader(String title, boolean partial, int sequence, List log, int position, boolean active) {
            this.title = title;
            this.partial = partial;
            this.sequence = sequence;
            this.log = log;
            this.position = position;
            this.active = active;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return this.position < this.log.size();
        }

        public boolean hasNextResponse() {
            return this.position < this.log.size();
        }

        public boolean getNextResponse(List lineReceiver) throws InterruptedException {
            if (this.position < this.log.size()) {
                lineReceiver.addAll((Collection)this.log.get(this.position++));
                return true;
            }
            return false;
        }

        public void close() {
        }

        public boolean isWritable() {
            return this.active;
        }
    }

    private static class RangeAnalyzeInputStream
    extends InputStream {
        private int range;
        private int lf;
        private int count;
        private InputStream in;

        public RangeAnalyzeInputStream(int range, InputStream in) {
            this.range = range;
            this.in = in;
            this.lf = range;
            this.count = range;
        }

        public int getRange() {
            return this.range;
        }

        public int read() throws IOException {
            int r = this.in.read();
            if (r == 10) {
                this.range = this.lf;
                this.lf = this.count + 1;
            }
            ++this.count;
            return r;
        }

        public int read(byte[] b) throws IOException {
            int r = this.in.read(b);
            int i = 0;
            while (i < r) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int r = this.in.read(b, off, len);
            int end = off + len;
            int i = off;
            while (i < end) {
                if (b[i] == 10) {
                    this.range = this.lf;
                    this.lf = this.count + i - off + 1;
                }
                ++i;
            }
            this.count += r;
            return r;
        }
    }

    private static class ThreadLogReader
    implements IResponseEnumeration {
        private CancelableRunner.ICancelableProgressMonitor monitor;
        private String title;
        private LogFile log;
        private int sequence;
        private boolean partial;
        private boolean active;

        public ThreadLogReader(CancelableRunner.ICancelableProgressMonitor monitor, String title, LogFile log, boolean partial, int sequence, boolean active) {
            this.monitor = monitor;
            this.title = title;
            this.log = log;
            this.sequence = sequence;
            this.partial = partial;
            this.active = active;
            monitor.beginTask("rendering...", log.responseCount);
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return this.partial;
        }

        public boolean isReady() {
            return this.hasNextResponse();
        }

        public boolean hasNextResponse() {
            return this.log.available();
        }

        public boolean getNextResponse(List lineReceiver) {
            try {
                this.monitor.worked(1);
                this.log.readResponse(lineReceiver);
                return true;
            }
            catch (IOException iOException) {
                this.log.close();
                return false;
            }
        }

        public void close() {
            this.log.close();
            this.monitor.done();
        }

        public boolean isWritable() {
            return this.active;
        }
    }

    private static class NullResponseEnumeration
    implements IResponseEnumeration {
        private String title;
        private int sequence;

        public NullResponseEnumeration(String title, int sequence) {
            this.title = title;
            this.sequence = sequence;
        }

        public int getSequenceNumber() {
            return this.sequence;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isPartialContent() {
            return true;
        }

        public boolean isReady() {
            return false;
        }

        public boolean hasNextResponse() {
            return false;
        }

        public boolean getNextResponse(List lineReceiver) {
            return false;
        }

        public void close() {
        }

        public boolean isWritable() {
            return false;
        }
    }

    private static class LogFile {
        private static final int LOG_FILE_VERSION = 12;
        private static final int RESPONSE_BODY_INDENT = 32;
        private static final int STYLE_UNDERLINE = 1;
        private static final int STYLE_LINK = 2;
        private DataInputStream din;
        public int version;
        public int sequence;
        public String title;
        public String lastModifierd;
        public boolean isActive;
        public int httpRangeStart;
        public int responseCount;
        private int responseRead;

        public static LogFile of(DataInputStream din) throws IOException {
            LogFile res;
            block4: {
                res = null;
                try {
                    int version = din.readInt();
                    if (version == 12) {
                        res = new LogFile(din);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    if (res == null) {
                        din.close();
                    }
                    throw throwable;
                }
                Object var3_5 = null;
                if (res != null) break block4;
                din.close();
            }
            return res;
        }

        LogFile(DataInputStream din) throws IOException {
            this.din = din;
            this.version = 12;
            this.sequence = din.readInt();
            this.title = din.readUTF();
            this.lastModifierd = din.readUTF();
            this.isActive = din.readInt() != 0;
            this.httpRangeStart = din.readInt();
            this.responseCount = din.readInt();
        }

        public void close() {
            try {
                if (this.din != null) {
                    this.din.close();
                }
                this.din = null;
            }
            catch (IOException iOException) {}
        }

        public boolean available() {
            return this.responseRead < this.responseCount;
        }

        public void skipResponse() throws IOException {
            this.din.skipBytes(this.din.readShort());
            int lineCount = this.din.readInt();
            int i = 0;
            while (i < lineCount) {
                int fragmentCount = this.din.readInt();
                int j = 0;
                while (j < fragmentCount) {
                    this.din.skipBytes(12);
                    this.din.skipBytes(this.din.readShort() + 8);
                    ++j;
                }
                ++i;
            }
        }

        public void readResponse(List lineReceiver) throws IOException {
            ++this.responseRead;
            String text = this.din.readUTF();
            int lineCount = this.din.readInt();
            int i = 0;
            while (i < lineCount) {
                ColoredText.Line line = i == 0 ? new ResponseHeaderLine(0, this.responseRead) : new ColoredText.Line(32);
                int fragmentCount = this.din.readInt();
                int j = 0;
                while (j < fragmentCount) {
                    int offset = this.din.readInt();
                    int length = this.din.readInt();
                    int style = this.din.readInt();
                    boolean isLink = (style & 2) != 0;
                    String link = "";
                    if (isLink) {
                        link = this.din.readUTF();
                    } else {
                        this.din.skipBytes(this.din.readShort());
                    }
                    int color = this.din.readInt();
                    int font = this.din.readInt();
                    if (isLink) {
                        if (color == 2) {
                            line.addLineFragment(new LinkedLineFragment(text, offset, length, color, font, (style & 1) != 0, false, link));
                        } else {
                            line.addLineFragment(new HoverLineFragment(text, offset, length, color, font, (style & 1) != 0, false, link));
                        }
                    } else {
                        line.addLineFragment(new MarkedLineFragment(text, offset, length, color, font, (style & 1) != 0, false));
                    }
                    ++j;
                }
                lineReceiver.add(line);
                ++i;
            }
        }

        private static int skipWhitespace(Reader r) throws IOException {
            int ch = r.read();
            while (ch != -1 && Character.isWhitespace((char)ch)) {
                ch = r.read();
            }
            return ch;
        }

        private static void convertMatches(String text, ColoredText.Line line, int color, int font, PatternAction[] patterns, boolean newMark, String urlBase) {
            int done = 0;
            Matcher[] matchers = new Matcher[patterns.length];
            int i = 0;
            while (i < matchers.length) {
                matchers[i] = patterns[i].matcher(text);
                ++i;
            }
            boolean[] matchs = new boolean[matchers.length];
            int i2 = 0;
            while (i2 < matchs.length) {
                matchs[i2] = patterns[i2].next(matchers[i2]);
                ++i2;
            }
            while (true) {
                int start = Integer.MAX_VALUE;
                int first = -1;
                int i3 = 0;
                while (i3 < matchs.length) {
                    if (matchs[i3] && matchers[i3].start() < start) {
                        start = matchers[i3].start();
                        first = i3;
                    }
                    ++i3;
                }
                if (first == -1) break;
                int end = matchers[first].end();
                if (done <= start) {
                    String link = patterns[first].getLink(urlBase, matchers[first]);
                    line.addLineFragment(new MarkedLineFragment(text, done, start - done, color, font, false, newMark));
                    if (patterns[first].isLink()) {
                        line.addLineFragment(new LinkedLineFragment(text, start, end - start, 2, font, true, newMark, link));
                    } else {
                        line.addLineFragment(new HoverLineFragment(text, start, end - start, color, font, true, newMark, link));
                    }
                    done = end;
                }
                matchs[first] = patterns[first].next(matchers[first]);
                if (!matchs[first] || matchers[first].start() != start) continue;
                matchs[first] = false;
            }
            line.addLineFragment(new MarkedLineFragment(text, done, text.length() - done, color, font, false, newMark));
        }

        private static ColoredText.Line readToken(Reader r, List lineReceiver, ColoredText.Line line, int color, int font, PatternAction[] patterns, boolean newMark, String urlBase) throws IOException {
            StringBuffer buf = new StringBuffer(128);
            int ch = r.read();
            while (ch == 32) {
                ch = r.read();
            }
            int sp = 0;
            while (ch != -1 && ch != 10) {
                if (ch == 60) {
                    String tag;
                    ch = r.read();
                    if (ch == 62) {
                        tag = null;
                    } else {
                        StringBuffer tagBuf = new StringBuffer(32);
                        while (ch != 62) {
                            tagBuf.append((char)ch);
                            ch = r.read();
                            if (ch != -1 && ch != 10) continue;
                            return null;
                        }
                        tag = tagBuf.toString().toLowerCase();
                        if (tag.equals("br") && sp > 0) {
                            buf.delete(buf.length() - sp, buf.length());
                        }
                        ch = r.read();
                    }
                    if (buf.length() > 0) {
                        String text = buf.toString();
                        if (patterns == null) {
                            line.addLineFragment(new MarkedLineFragment(text, 0, text.length(), color, font, false, newMark));
                        } else {
                            LogFile.convertMatches(text, line, color, font, patterns, newMark, urlBase);
                        }
                    }
                    buf = new StringBuffer(128);
                    if (tag == null) {
                        return line;
                    }
                    if (tag.equals("b")) {
                        font = 1;
                    } else if (tag.equals("/b")) {
                        font = 0;
                    } else if (tag.equals("br")) {
                        lineReceiver.add(line);
                        line = new ColoredText.Line(32);
                        while (ch == 32) {
                            ch = r.read();
                        }
                    } else if (!tag.startsWith("a ")) {
                        if (tag.indexOf("red") != -1) {
                            color = 1;
                        } else if (tag.indexOf("forestgreen") != -1) {
                            color = 3;
                        }
                    }
                    sp = 0;
                    continue;
                }
                if (ch == 38) {
                    ch = r.read();
                    if (ch == 35) {
                        ch = r.read();
                        boolean x16 = false;
                        if (ch == 120) {
                            x16 = true;
                            ch = r.read();
                        }
                        StringBuffer b = new StringBuffer();
                        while (Character.isDigit((char)ch) && b.length() < 5) {
                            b.append((char)ch);
                            ch = r.read();
                        }
                        try {
                            buf.append((char)Integer.parseInt(b.toString(), x16 ? 16 : 10));
                        }
                        catch (NumberFormatException numberFormatException) {
                            buf.append("&#");
                            if (x16) {
                                buf.append('x');
                            }
                            buf.append(b.toString());
                            if (ch == 59) {
                                buf.append(';');
                            }
                        }
                    } else {
                        StringBuffer b = new StringBuffer();
                        while (Character.isLetter((char)ch) && b.length() < 6) {
                            b.append((char)ch);
                            ch = r.read();
                        }
                        String ref = b.toString();
                        if (ref.equals("lt")) {
                            buf.append('<');
                        } else if (ref.equals("gt")) {
                            buf.append('>');
                        } else if (ref.equals("amp")) {
                            buf.append('&');
                        } else if (ref.equals("apos")) {
                            buf.append('\'');
                        } else if (ref.equals("quot")) {
                            buf.append('\"');
                        } else if (ref.equals("hearts")) {
                            buf.append('\u2665');
                        } else if (ref.equals("thinsp")) {
                            buf.append('\u2009');
                        } else if (ref.equals("nbsp")) {
                            buf.append(' ');
                        } else if (ref.equals("ensp")) {
                            buf.append('\u2002');
                        } else if (ref.equals("emsp")) {
                            buf.append('\u2003');
                        } else {
                            buf.append('&').append(String.valueOf(ref) + (ch == 59 ? ";" : ""));
                        }
                    }
                    sp = 0;
                    if (ch != 59) continue;
                    ch = r.read();
                    continue;
                }
                sp = ch == 32 ? ++sp : 0;
                buf.append((char)ch);
                ch = r.read();
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static String parseResponse(Reader r, List lineReceiver, int responseNumber, String urlBase) throws IOException {
            String string;
            int lineCount;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            lineCount = lineReceiver.size();
                            try {
                                block11: {
                                    try {
                                        ResponseHeaderLine headerLine = new ResponseHeaderLine(0, responseNumber);
                                        headerLine.addLineFragment(new ColoredText.LineFragment(String.valueOf(responseNumber) + " : ", 0, 0, false));
                                        if (LogFile.readToken(r, null, headerLine, 3, 1, NAME_PATTERN_SET, false, urlBase) == null) {
                                            Object var10_6 = null;
                                            break block11;
                                        }
                                        headerLine.addLineFragment(new ColoredText.LineFragment(" ", 0, 0, false));
                                        if (LogFile.readToken(r, null, headerLine, 2, 1, MAIL_PATTERN_SET, false, urlBase) == null) {
                                            break block12;
                                        }
                                        headerLine.addLineFragment(new ColoredText.LineFragment(" : ", 0, 0, false));
                                        if (LogFile.readToken(r, null, headerLine, 0, 0, DATE_PATTERN_SET, true, urlBase) == null) {
                                            break block13;
                                        }
                                        lineReceiver.add(headerLine);
                                        ColoredText.Line line = LogFile.readToken(r, lineReceiver, new ColoredText.Line(32), 0, 0, BODY_PATTERN_SET, false, urlBase);
                                        if (line == null) {
                                            break block14;
                                        }
                                        lineReceiver.add(line);
                                        String title = null;
                                        int ch = r.read();
                                        if (ch != -1 && ch != 10) {
                                            StringBuffer buf = new StringBuffer();
                                            while (true) {
                                                if (ch == -1 || ch == 10) {
                                                    title = buf.toString();
                                                    break;
                                                }
                                                buf.append((char)ch);
                                                ch = r.read();
                                            }
                                        }
                                        string = title;
                                        break block15;
                                    }
                                    catch (RuntimeException runtimeException) {
                                        Object var10_11 = null;
                                        if (lineCount == lineReceiver.size()) return null;
                                        lineReceiver.add(new ColoredText.Line(32));
                                        return null;
                                    }
                                }
                                if (lineCount == lineReceiver.size()) return null;
                                lineReceiver.add(new ColoredText.Line(32));
                                return null;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                if (lineCount == lineReceiver.size()) throw throwable;
                                lineReceiver.add(new ColoredText.Line(32));
                                throw throwable;
                            }
                        }
                        Object var10_7 = null;
                        if (lineCount == lineReceiver.size()) return null;
                        lineReceiver.add(new ColoredText.Line(32));
                        return null;
                    }
                    Object var10_8 = null;
                    if (lineCount == lineReceiver.size()) return null;
                    lineReceiver.add(new ColoredText.Line(32));
                    return null;
                }
                Object var10_9 = null;
                if (lineCount == lineReceiver.size()) return null;
                lineReceiver.add(new ColoredText.Line(32));
                return null;
            }
            Object var10_10 = null;
            if (lineCount == lineReceiver.size()) return string;
            lineReceiver.add(new ColoredText.Line(32));
            return string;
        }

        private static void writeLogFile(DataOutputStream dout, int sequence, String title, String lastModified, boolean isActive, int httpRangeStart, List logs) throws IOException {
            dout.writeInt(12);
            dout.writeInt(sequence);
            dout.writeUTF(title);
            dout.writeUTF(lastModified);
            dout.writeInt(isActive ? 1 : 0);
            dout.writeInt(httpRangeStart);
            dout.writeInt(logs.size());
            int i = 0;
            while (i < logs.size()) {
                List resp = (List)logs.get(i);
                StringBuffer buf = new StringBuffer();
                int j = 0;
                while (j < resp.size()) {
                    ColoredText.Line line = (ColoredText.Line)resp.get(j);
                    buf.append(line.getText());
                    ++j;
                }
                dout.writeUTF(buf.toString());
                int textOffset = 0;
                dout.writeInt(resp.size());
                int j2 = 0;
                while (j2 < resp.size()) {
                    ColoredText.Line line = (ColoredText.Line)resp.get(j2);
                    dout.writeInt(line.getLineFragmentCount());
                    int k = 0;
                    while (k < line.getLineFragmentCount()) {
                        int style;
                        ColoredText.LineFragment frag = line.getLineFragmentAt(k);
                        dout.writeInt(textOffset);
                        dout.writeInt(frag.getTextLength());
                        textOffset += frag.getTextLength();
                        int n = style = frag.getUnderline() ? 1 : 0;
                        if (frag instanceof HoverLineFragment) {
                            dout.writeInt(style | 2);
                            dout.writeUTF(((HoverLineFragment)frag).getReference());
                        } else {
                            dout.writeInt(style);
                            dout.writeUTF("");
                        }
                        dout.writeInt(frag.getColor());
                        dout.writeInt(frag.getFont());
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
        }
    }

    private static abstract class PatternAction {
        private Pattern pattern;

        public PatternAction(Pattern pattern) {
            this.pattern = pattern;
        }

        public Matcher matcher(String text) {
            return this.pattern.matcher(text);
        }

        public boolean next(Matcher m) {
            return m.find();
        }

        public boolean isLink() {
            return true;
        }

        public abstract String getLink(String var1, Matcher var2);
    }

    private static class LinkedLineFragment
    extends HoverLineFragment
    implements ILinkedLineFragment {
        public LinkedLineFragment(String text, int offset, int length, int color, int font, boolean underline, boolean newMark, String href) {
            super(text, offset, length, color, font, underline, newMark, href);
        }

        public String getURL() {
            return this.getReference();
        }

        public int getResponseFragment() {
            String href = this.getReference();
            String pos = href.substring(href.lastIndexOf(47) + 1, href.length());
            Pattern p = Pattern.compile("(\\p{Digit}+)(-(\\p{Digit}*))?");
            Matcher m = p.matcher(pos);
            if (m.lookingAt()) {
                return Integer.parseInt(m.group(1));
            }
            return -1;
        }
    }

    private static class HoverLineFragment
    extends MarkedLineFragment
    implements ColoredText.ToolTipTarget {
        private String href;

        public HoverLineFragment(String text, int offset, int length, int color, int font, boolean underline, boolean newMark, String href) {
            super(text, offset, length, color, font, underline, newMark);
            this.href = href;
        }

        public String getReference() {
            return this.href;
        }

        public void prefetchToolTip() {
        }

        public Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String sourceTitle) {
            ArrayList<ColoredText.Line> lines = new ArrayList<ColoredText.Line>();
            String toolTipTitle = null;
            String altText = this.href;
            if (this.href.startsWith("id:") || this.href.startsWith("trip:")) {
                boolean copy = false;
                int i = 0;
                while (i < sourceText.getLineCount()) {
                    ColoredText.Line line = sourceText.getLineAt(i);
                    if (line instanceof ResponseHeaderLine) {
                        copy = false;
                        int j = 0;
                        while (j < line.getLineFragmentCount()) {
                            ColoredText.LineFragment f = line.getLineFragmentAt(j);
                            if (f instanceof HoverLineFragment && ((HoverLineFragment)f).getReference().equals(this.href)) {
                                copy = true;
                            }
                            ++j;
                        }
                    }
                    if (copy) {
                        lines.add(line);
                    }
                    ++i;
                }
            } else if (this.href.startsWith("http")) {
                try {
                    IThreadContentProvider cp = BBSServerManager.getThreadContentProviderOf(new URL(this.href));
                    if (cp != null) {
                        String targetTitle;
                        String pos = this.href.substring(this.href.lastIndexOf(47) + 1, this.href.length());
                        Pattern p = Pattern.compile("(\\p{Digit}+)(-(\\p{Digit}*))?");
                        Matcher m = p.matcher(pos);
                        if (m.lookingAt()) {
                            int start;
                            String s = m.group(1);
                            int end = start = Integer.parseInt(s);
                            String e = m.group(3);
                            if (e != null) {
                                end = Integer.parseInt(e);
                            }
                            if (end < start) {
                                int t = start;
                                start = end;
                                end = t;
                            }
                            targetTitle = cp.getResponses(lines, start, end);
                        } else {
                            targetTitle = cp.getResponses(lines, 1, 1);
                        }
                        if (targetTitle != null && sourceTitle != null && !sourceTitle.equals(targetTitle)) {
                            toolTipTitle = targetTitle;
                        }
                        if (lines.size() == 0 && cp.getName().length() > 0) {
                            return HoverLineFragment.createColoredTextToolTip(parent, sourceText, maxWidth, cp.getName(), lines);
                        }
                    } else {
                        IBBSBoard board = BBSServerManager.getBoardOf(new URL(this.href));
                        if (board != null) {
                            altText = board.getName();
                        }
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            int i = lines.size() - 1;
            while (i >= 0) {
                ColoredText.Line line = (ColoredText.Line)lines.get(i);
                if (line.getLineFragmentCount() != 0) break;
                lines.remove(i);
                --i;
            }
            return HoverLineFragment.createToolTip(parent, sourceText, maxWidth, toolTipTitle, lines, altText);
        }

        public static Point fillToolTip(Composite parent, ColoredText sourceText, int maxWidth, String selection, String sourceTitle) {
            ColoredText.Line line;
            int i;
            ArrayList<ColoredText.Line> lines = new ArrayList<ColoredText.Line>();
            try {
                int num = Integer.parseInt(selection.trim());
                boolean copy = false;
                i = 0;
                while (i < sourceText.getLineCount()) {
                    line = sourceText.getLineAt(i);
                    if (line instanceof ResponseHeaderLine) {
                        ResponseHeaderLine rhl = (ResponseHeaderLine)line;
                        boolean bl = copy = num == rhl.getReponseNumber();
                    }
                    if (copy) {
                        lines.add(line);
                    }
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (lines.size() == 0) {
                boolean copy = false;
                int lastHeader = 0;
                i = 0;
                while (i < sourceText.getLineCount()) {
                    line = sourceText.getLineAt(i);
                    if (line instanceof ResponseHeaderLine) {
                        int j = lastHeader;
                        while (copy && j < i) {
                            lines.add(sourceText.getLineAt(j));
                            ++j;
                        }
                        copy = false;
                        lastHeader = i;
                    }
                    if (line.toString().indexOf(selection) != -1) {
                        copy = true;
                    }
                    ++i;
                }
                int j = lastHeader;
                while (copy & j < sourceText.getLineCount()) {
                    lines.add(sourceText.getLineAt(j));
                    ++j;
                }
            }
            return HoverLineFragment.createToolTip(parent, sourceText, maxWidth, null, lines, "(not found)");
        }

        private static Point createToolTip(Composite parent, ColoredText sourceText, int maxWidth, String title, List lines, String errorMsg) {
            if (lines.size() > 0) {
                return HoverLineFragment.createColoredTextToolTip(parent, sourceText, maxWidth, title, lines);
            }
            Label label = new Label(parent, 0);
            label.setText(errorMsg);
            return label.computeSize(-1, -1);
        }

        private static Point createColoredTextToolTip(Composite parent, ColoredText sourceText, int maxWidth, String title, List lines) {
            ColoredText text = new ColoredText(parent, 512);
            text.setBackground(sourceText.getBackground());
            text.setToolTipProvider(sourceText.getToolTipProvider());
            text.setToolTipSource(sourceText);
            text.setLinkProvider(sourceText.getLinkProvider());
            if (title != null) {
                ColoredText.Line line = new ColoredText.Line(0);
                line.addLineFragment(new ColoredText.LineFragment(title, 1, 0, false));
                text.addLine(line);
                if (lines.size() > 0) {
                    text.addLine(new ColoredText.Line(0));
                }
            }
            text.addLines(lines);
            Point size = text.computeSize(-1, -1, true);
            if (maxWidth < size.x) {
                size = new Point(maxWidth, text.setWrapWidth(maxWidth));
            }
            text.setSize(size);
            return size;
        }
    }

    private static class MarkedLineFragment
    extends ColoredText.LineFragment
    implements INewResponseLineFragment {
        private int color;
        private boolean newMark;

        public MarkedLineFragment(String text, int offset, int length, int color, int font, boolean underline, boolean newMark) {
            super(text, offset, length, newMark ? 1 : color, font, underline);
            this.color = color;
            this.newMark = newMark;
        }

        public void unmark() {
            if (this.newMark) {
                this.setColor(this.color);
            }
        }

        public int getColor() {
            return this.color;
        }
    }

    private static class ResponseHeaderLine
    extends ColoredText.Line
    implements IResponseHeaderLine {
        private int responseNumber;

        public ResponseHeaderLine(int indent, int responseNumber) {
            super(indent);
            this.responseNumber = responseNumber;
        }

        public int getReponseNumber() {
            return this.responseNumber;
        }
    }

    private static class URLConnectionListener
    implements IURLConnectionListener {
        private CancelableRunner cancelable;
        private HttpURLConnection connection;

        public URLConnectionListener(CancelableRunner cancelable) {
            this.cancelable = cancelable;
        }

        public void connectionOpened(URLConnection conn) {
            if (conn instanceof HttpURLConnection) {
                this.connection = (HttpURLConnection)conn;
                this.cancelable.openConnection(this.connection);
            }
        }

        public void close() {
            if (this.connection != null) {
                this.cancelable.closeConnection(this.connection);
                this.connection = null;
            }
        }
    }
}

