package monalipse.editors;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class ThreadEditorInputFactory implements IElementFactory
{
	private static final String ID_FACTORY =  ThreadEditorInputFactory.class.getName();

	private static final String TAG_BASEURL = "baseURL";
	private static final String TAG_URLHINT = "urlHint";
	private static final String TAG_FOLDER = "folder";
	private static final String TAG_ID = "id";
	private static final String TAG_TITLE = "title";
	private static final String TAG_TOOLTIP = "tooltip";

	public ThreadEditorInputFactory()
	{
	}

	public IAdaptable createElement(IMemento memento)
	{
		String baseURL = memento.getString(TAG_BASEURL);
		String urlHint = memento.getString(TAG_URLHINT);
		String folder = memento.getString(TAG_FOLDER);
		String id = memento.getString(TAG_ID);
		String title = memento.getString(TAG_TITLE);
		String tooltip = memento.getString(TAG_TOOLTIP);
		
		if(baseURL != null && urlHint != null && folder != null && id != null && title != null && tooltip != null)
			return new ThreadEditorInput(baseURL, urlHint, ResourcesPlugin.getWorkspace().getRoot().getFolder(new Path(folder)), id, title, tooltip);
		else
			return null;
	}

	public static String getFactoryId()
	{
		return ID_FACTORY;
	}

	public static void saveState(IMemento memento, ThreadEditorInput input)
	{
		memento.putString(TAG_BASEURL, input.getBaseURL());
		memento.putString(TAG_URLHINT, input.getURLHint());
		memento.putString(TAG_FOLDER, input.getLogFolder().getFullPath().toString());
		memento.putString(TAG_ID, input.getID());
		memento.putString(TAG_TITLE, input.getTitle());
		memento.putString(TAG_TOOLTIP, input.getToolTipText());
	}
}
