package monalipse.part;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CancelableRunner extends SubStatusLineManager
{
	private StatusLineProgressMonitorPart monitor;
	private Display display;
	private IAction cancelAction;

	public CancelableRunner(IStatusLineManager mgr, Display display, IAction cancelAction)
	{
		super(mgr);
		
		this.display = display;
		this.cancelAction = cancelAction;

		add(new ControlContribution(CancelableRunner.class.getName() + ".progress")
			{
				protected Control createControl(Composite parent)
				{
					monitor = new StatusLineProgressMonitorPart(parent, CancelableRunner.this, CancelableRunner.this.cancelAction);
					return monitor;
				}
			});
		add(cancelAction);
	}
	
	public void setDisplay(Display display)
	{
		this.display = display;
	}
	
	private void ensureVisible(Display display)
	{
		display.syncExec(new Runnable()
			{
				public void run()
				{
					setVisible(true);
					cancelAction.setEnabled(true);
					update(true);
				}
			});
	}
	
	public void cancel()
	{
		if(monitor != null && !monitor.isDisposed())
			monitor.interruptAll();
	}

	public void runAndJoin(Object serializeKey, IRunnableWithProgress run)
	{
		try
		{
			run(serializeKey, run).join();
		}
		catch (InterruptedException e)
		{
			e.printStackTrace();
		}
	}
	
	public Thread run(Object serializeKey, IRunnableWithProgress run)
	{
		ensureVisible(display);
		if(monitor != null && !monitor.isDisposed())
			return monitor.run(serializeKey, run);
		else
			return runSilent(serializeKey, run);
	}
	
	private Thread runSilent(final Object serializeKey, final IRunnableWithProgress run)
	{
		Thread thread = new Thread(new Runnable()
			{
				public void run()
				{
					if(serializeKey == null)
					{
						runInternal();
					}
					else
					{
						synchronized(serializeKey)
						{
							runInternal();
						}
					}
				}

				public void runInternal()
				{
					try
					{
						run.run(new NullProgressMonitor());
					}
					catch (InvocationTargetException e)
					{
						 e.printStackTrace();
					}
					catch (InterruptedException e)
					{
						 e.printStackTrace();
					}
				}
			}, getClass().getName());

		thread.start();
		return thread;
	}
}
