<?php
//
// +--------------------------------------------------------------------+
// | PHP version 4                                                      |
// +--------------------------------------------------------------------+
// | Copyright (c) 2005 the Moony project                               |
// +--------------------------------------------------------------------+
// | This source file is subject to version 3.00 of the PHP License,    |
// | that is available at http://www.php.net/license/3_0.txt.           |
// | If you did not receive a copy of the PHP license and are unable to |
// | obtain it through the world-wide-web, please send a note to        |
// | license@php.net so we can mail you a copy immediately.             |
// +--------------------------------------------------------------------+
// | Authors: YAMAOKA Hiroyuki <yamaoka@catwalker.jp>                   |
// +--------------------------------------------------------------------+
//

define('MOONY_BASE', dirname(dirname(__FILE__)));

require_once MOONY_BASE . '/lib/moony/Moony_Config.php';

if ($_SERVER['argc'] != 2) {
    $message = "Parameter Error...\n";
    $message .= "usage: /path/to/php generate.php [action_name]\n";
}

$action_name = $_SERVER['argv'][1];

$action_file = MOONY_ACTION_DIR . '/' . $action_name . 'Action.' . MOONY_ACTION_EXT;
$template_file = MOONY_SMARTY_TEMPLATE_DIR . '/' . $action_name . '.' . MOONY_SMARTY_TEMPLATE_EXT;

if (file_exists($action_file)) {
    die("Error: Action Class File Already Exists\n");
}
if (file_exists($template_file)) {
    die("Error: Template File Already Exists\n");
}

$skelton_dir = MOONY_BASE . '/_codegen/skelton';
$action_tpl = file_get_contents($skelton_dir . '/action.skl');
$template_tpl = file_get_contents($skelton_dir . '/template.skl');

$action_content = sprintf($action_tpl, $action_name . 'Action');
$template_content = sprintf($template_tpl, $action_name);

$fp = fopen($action_file, 'w');
fputs($fp, $action_content);
fclose($fp);

$fp = fopen($template_file, 'w');
fputs($fp, $template_content);
fclose($fp);

echo "Skelton for '$action_name' Successfully Generated!\n";
?>
