<?php
//
// +--------------------------------------------------------------------+
// | PHP version 4                                                      |
// +--------------------------------------------------------------------+
// | Copyright (c) 2005 The Moony Project                               |
// +--------------------------------------------------------------------+
// | This source file is subject to version 3.00 of the PHP License,    |
// | that is available at http://www.php.net/license/3_0.txt.           |
// | If you did not receive a copy of the PHP license and are unable to |
// | obtain it through the world-wide-web, please send a note to        |
// | license@php.net so we can mail you a copy immediately.             |
// +--------------------------------------------------------------------+
// | Authors: YAMAOKA Hiroyuki <yamaoka@catwalker.jp>                   |
// +--------------------------------------------------------------------+
//

/**
 * ȥ饯饹Ǥ
 * ꡦưԤޤ
 * 
 * @access public
 * @package moony.core
 */
class Moony_Controller {

    /** @var string ̾ */
    var $_action_name;

    /** @var array Υѥ᡼ʬ */
    var $_params;

    /**
     * 󥹥ȥ饯Ǥ
     * 
     * @access public
     */
    function Moony_Controller() {
    }

    /**
     * ꡼ʸβϤԤ
     * ̾ꤷޤ
     * ̾ꤵƤʤ硢
     * config.phpꤵ줿ǥեȥ̾Ѥޤ
     * 
     * @access public
     * @param string $query_string ꡼ʸ
     */
    function init($query_string) {

        $settings = split('/', $query_string);

        // ̾ȤΩ
        $this->_action_name = '';
        for ($i = 0; $i < MOONY_EVAL_AS_ACTION_SETTING; $i++) {
            if (isset($settings[$i])) {
                $this->_action_name .= ucfirst($settings[$i]);
            }
        }

        // ꤵƤʤ硢ǥեȥ
        if (strlen($this->_action_name) == 0) {
            $this->_action_name = MOONY_DEFAULT_ACTION_NAME;
        }

        // ̾ȤƻѤʤѥ᡼
        $this->_params = array_slice($settings, MOONY_EVAL_AS_ACTION_SETTING);
    }

    /**
     * ºݤνԤޤưޤ
     * ޤꤵ줿б륯饹¸ߤʤϡ
     * ̵˥̾ɳդƥץ졼Ȥɽޤ
     * 
     * @access public
     */
    function process() {

        $class_name = $this->_action_name . 'Action';
        $class_path = MOONY_ACTION_DIR . '/' . $class_name . '.' . MOONY_ACTION_EXT;

        // httpإå
        header('X-Framework: Moony/' . MOONY_VERSION);

        if (!file_exists($class_path)) {
            // 󥯥饹¸ߤʤ
            $view =& new Moony_View();
            $view->init($this->_action_name);
            if (MOONY_SMARTY_USE_CACHE_WITHOUT_ACTION) {
                $view->cache();
            }
            $view->forward();
            exit;
        }

        include_once $class_path;
        $action =& new $class_name;

        $request =& new Moony_Request();
        $request->store();

        $view =& new Moony_View();
        $view->init($this->_action_name);

        $session =& new Moony_Session();
        $session->start();

        $action->init($this->_params);
        $action->execute($request, $session, $view);
    }
}
?>