<?php
//
// +--------------------------------------------------------------------+
// | PHP version 4                                                      |
// +--------------------------------------------------------------------+
// | Copyright (c) 2005 The Moony Project                               |
// +--------------------------------------------------------------------+
// | This source file is subject to version 3.00 of the PHP License,    |
// | that is available at http://www.php.net/license/3_0.txt.           |
// | If you did not receive a copy of the PHP license and are unable to |
// | obtain it through the world-wide-web, please send a note to        |
// | license@php.net so we can mail you a copy immediately.             |
// +--------------------------------------------------------------------+
// | Authors: YAMAOKA Hiroyuki <yamaoka@catwalker.jp>                   |
// +--------------------------------------------------------------------+
//

/**
 * åǼ륯饹Ǥ
 * 
 * @access public
 * @package moony.core
 */
class Moony_Session {

    /** @var bool å󤬳ϤƤ뤫ɤ */
    var $_has_started = false;

    /**
     * 󥹥ȥ饯Ǥ
     * 
     * @access public
     */
    function Moony_Session() {
    }

    /**
     * å򳫻Ϥޤ
     * åID
     * Ťåեޤ
     * 
     * @access public
     */
    function start() {

        session_start();
        $stored = serialize($_SESSION);
        
        session_destroy();
        session_id(md5(uniqid(rand(), true)));

        session_start();
        $_SESSION = unserialize($stored);

        $this->_has_started = true;
    }

    /**
     * åλޤ
     * 
     * @access public
     * @return ˽λ<code>true</code>
     */
    function destroy() {

        if (!$this->_has_started) {
            return true;
        }

        $_SESSION = array();

        if (isset($_COOKIE[session_name()])) {
            setcookie(session_name(), '', time() - 42000, '/');
        }

        session_destroy();
        $this->_has_started = false;

        return true;
    }

    /**
     * å˳Ǽ줿ͤޤ
     * ꤵ줿ɳդͤꤵƤʤ硢
     * ֤ͤޤ
     * 
     * @access public
     * @param string $key Ǽ
     * @param mixed $alt 
     * @return Ǽ
     */
    function get($key, $alt = null) {

        if (!$this->_has_started) {
            return $alt;
        }

        if (!isset($_SESSION[$key])) {
            return $alt;
        }

        return $_SESSION[$key];
    }

    /**
     * åͤꤷޤ
     * 
     * @access public
     * @param string $key Ǽ
     * @param mixed $value Ǽ
     * @return bool ˽λ<code>true</code>
     */
    function set($key, $value) {

        if (!$this->_has_started) {
            return false;
        }

        $_SESSION[$key] = $value;
        return true;
    }

    /**
     * å󤫤ͤޤ
     * 
     * @access public
     * @param string $key Ǽ
     * @return bool ˽λ<code>true</code>
     */
    function remove($key) {

        if (!$this->_has_started) {
            return false;
        }

        unset($_SESSION[$key]);
        return true;
    }
}
?>