<?php
//
// +--------------------------------------------------------------------+
// | PHP version 4                                                      |
// +--------------------------------------------------------------------+
// | Copyright (c) 2005 The Moony Project                               |
// +--------------------------------------------------------------------+
// | This source file is subject to version 3.00 of the PHP License,    |
// | that is available at http://www.php.net/license/3_0.txt.           |
// | If you did not receive a copy of the PHP license and are unable to |
// | obtain it through the world-wide-web, please send a note to        |
// | license@php.net so we can mail you a copy immediately.             |
// +--------------------------------------------------------------------+
// | Authors: YAMAOKA Hiroyuki <yamaoka@catwalker.jp>                   |
// +--------------------------------------------------------------------+
//

/**
 * SmartyѤơ
 * ƥץ졼ȤؤͤȲɽԤΥ饹Ǥ
 * 
 * @access public
 * @package moony.core
 */
class Moony_View {

    /** @var object Smarty饹Υ󥹥 */
    var $_smarty;

    /** @var array ƥץ졼Ȥꤹѥ᡼ */
    var $_items;

    /** @var string ̾ */
    var $_action_name;

    /**
     * 󥹥ȥ饯Ǥ
     * 
     * @access public
     */
    function Moony_View() {
    }

    /**
     * Ԥޤ
     * 
     * @access public
     * @param string $action_name ̾
     */
    function init($action_name) {

        $this->_smarty =& new Smarty();

        $this->_smarty->template_dir = MOONY_SMARTY_TEMPLATE_DIR;
        $this->_smarty->compile_dir = MOONY_SMARTY_COMPILE_DIR;
        $this->_smarty->cache_dir = MOONY_SMARTY_CACHE_DIR;
        $this->_smarty->compile_check = MOONY_SMARTY_COMPILE_CHECK;

        $this->_items = array();
        $this->_action_name = $action_name;
    }

    /**
     * ƥץ졼Ȥꤹѥ᡼ꤷޤ
     * 
     * @access public
     * @param string $key ѥ᡼
     * @param mixed $value ѥ᡼
     */
    function assign($key, $value) {
        $this->_items[$key] = $value;
    }

    /**
     * ƥץ졼ɽԤޤ
     * 
     * @access public
     * @param string $name ƥץ졼ȥե̾Υեåʥǥե<code>null</code>
     */
    function forward($name = null) {

        if (strlen($name) == 0) {
            $this->_display($this->_action_name . '.' . MOONY_SMARTY_TEMPLATE_EXT);
            return;
        }

        $this->_display($this->_action_name . ucfirst($name) . '.' . MOONY_SMARTY_TEMPLATE_EXT);
    }

    /**
     * ƥץ졼ȤΥѥ̤򥭥å夹뤳Ȥޤ
     *
     * @access public
     * @param int $lifetime å¸֡ñ̡ǥեȤ3600á
     */
    function cache($lifetime = 3600) {
        $this->_smarty->caching = 2;
        $this->_smarty->cache_lifetime = $lifetime;
    }

    /**
     * ꤵ줿̾ΤΥƥץ졼Ȥ
     * å夵Ƥ뤫ɤĴ٤ޤ
     * Υ᥽åɤ¹ԤƱ̾Υƥץ졼ȤѤϡ
     * ̵˥å夵ޤ
     *
     * @access public
     * @param string $name ƥץ졼ȥե̾Υեåʥǥե<code>null</code>
     * @return å夵Ƥ<code>true</code>
     */
    function hasCached($name = null) {

        $this->_smarty->caching = true;

        $template = '';
        if (strlen($name) == 0) {
            $template = $this->_action_name . '.' . MOONY_SMARTY_TEMPLATE_EXT;
        } else {
            $template = $this->_action_name . ucfirst($name) . '.' . MOONY_SMARTY_TEMPLATE_EXT;
        }

        return $this->_smarty->is_cached($template);
    }

    /**
     * ƥץ졼Ȥ˥ѥ᡼ꤷɽԤޤ
     * 
     * @access private
     * @param string $template ƥץ졼ȥե̾
     */
    function _display($template) {

        // ¸ߥå
        $file = $this->_smarty->template_dir . '/' . $template;
        if (!file_exists($file)) {
            header('HTTP/1.0 404 Not Found');
            exit;
        }

        foreach ($this->_items as $key => $value) {
            $this->_smarty->assign($key, $value);
        }

        $this->_smarty->display($template);
    }
}
?>