<?php
/**
 * Moonyの動作に関する設定を行います。
 * 
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */

// ログ出力レベルの定義
define('MOONY_LOG_LEVEL_FATAL', 5);
define('MOONY_LOG_LEVEL_ERROR', 4);
define('MOONY_LOG_LEVEL_WARN',  3);
define('MOONY_LOG_LEVEL_INFO',  2);
define('MOONY_LOG_LEVEL_DEBUG', 1);
define('MOONY_LOG_LEVEL_NONE',  0);

// Moonyのバージョン表記
define('MOONY_VERSION', '0.8.0');

// Moonyの内部エンコーディング（変更しないでください）
define('MOONY_INTERNAL_ENCODING', 'UTF-8');

// Moonyの出力エンコーディング
define('MOONY_OUTPUT_ENCODING', 'SJIS');

// テンプレートファイルのエンコーディング
define('MOONY_TEMPLATE_ENCODING', 'UTF-8');

// リクエストパラメータのエンコーディング変換を行うかどうか
define('MOONY_REQUEST_PARAMETER_CONVERT_ENCODING', true);

// テンプレート表示時にHTMLのエンコーディングに関するヘッダ送出を行うかどうか
define('MOONY_SENDING_HEADER_ABOUT_ENCODING', true);

// XHTMLとしてのヘッダ（application/xhtml+xml）を使用するかどうか
define('MOONY_USE_XHTML_HEADER', false);

// アクション名称が指定されない場合のデフォルトアクション名
define('MOONY_DEFAULT_ACTION_NAME', 'Index');

// URLの何階層目までをアクション設定として解釈するか
define('MOONY_EVAL_AS_ACTION_SETTING', 2);

// セッションを自動的に開始するかどうか
define('MOONY_SESSION_AUTO_START', true);

// 常にセッションIDの再生成を行うかどうか
define('MOONY_REGENERATE_SESSION_ID', false);

// Smartyのキャッシュ機能をアクションクラスがない場合にデフォルトで使用するかどうか
define('MOONY_SMARTY_USE_CACHE_WITHOUT_ACTION', false);

// Moonyのログファイル名称
define('MOONY_LOG_FILE', 'moony.log');

// ログファイルに出力する日付の形式（date関数を利用）
define('MOONY_LOG_DATE_FORMAT', 'Y/m/d H:i:s');

// ログ出力を行うログレベルの閾値
define('MOONY_LOG_CATEGORY', MOONY_LOG_LEVEL_INFO);

// ログのローテートを行うかどうか
define('MOONY_LOG_ROTATE', true);

// アクションクラスの拡張子
define('MOONY_ACTION_EXT', 'php');

// Smartyのテンプレートファイルの拡張子
define('MOONY_SMARTY_TEMPLATE_EXT', 'tpl');

// テンプレートファイルが存在しない場合に404を返す場合に表示したいメッセージ
// （設定しない場合は空文字にしておいてください）
define('MOONY_404_MESSAGE', '');

// アプリケーションでエラーが発生した場合に500を返す場合に表示したいメッセージ
// （設定しない場合は空文字にしておいてください）
define('MOONY_500_MESSAGE', '');


if (!defined('PATH_SEPARATOR')) {
    if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
        define('PATH_SEPARATOR', ';');
    } else {
        define('PATH_SEPARATOR', ':');
    }
}

if (!defined('DIRECTORY_SEPARATOR')) {
    if (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN') {
        define('DIRECTORY_SEPARATOR', '\\');
    } else {
        define('DIRECTORY_SEPARATOR', '/');
    }
}
?>
