<?php
/**
 * コントローラクラスです。
 * アクションの設定・起動を行います。
 * 
 * @package Moony
 * @subpackage core
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_Controller
{
    /**
     * コンストラクタです。
     * 
     * @access public
     */
    function Moony_Controller()
    {
    }

    /**
     * 実際の処理を行います。アクションを起動します。
     * また、指定されたアクションに対応するクラスが存在しない場合は、
     * 無条件にアクション名に紐付くテンプレートを表示させます。
     * 
     * @access public
     * @param string $action_name アクション名称
     * @param array $path_info PATH_INFOの値の配列
     */
    function process($action_name, $path_info)
    {
        // フレームワーク情報をHTTPヘッダ出力
        header('X-Framework: Moony/' . MOONY_VERSION);

        // テンプレート名称初期値
        $template = Moony_Utils::buildPath('', $action_name, MOONY_SMARTY_TEMPLATE_EXT);

        // Session生成
        $session =& new Moony_Session();
        if (MOONY_SESSION_AUTO_START) {
            $session->start();
        }

        // Request生成
        $request =& new Moony_Request();
        $request->setSession($session);
        $request->setPathInfo($path_info);

        // Response生成
        $response =& new Moony_Response();
        $response->setTemplate($template);

        // View生成
        $view =& Moony_View::getInstance();

        // アクションクラスに関する情報組み立て
        $action_class_name = $action_name . 'Action';
        $action_class_path = Moony_Utils::buildPath(MOONY_ACTION_DIR, $action_class_name, MOONY_ACTION_EXT);

        if (file_exists($action_class_path)) {

            // アクション実行
            include_once $action_class_path;
            $action =& new $action_class_name;
            $action->execute(&$request, &$response);

            // HTTPステータス送出
            $status = $response->getStatus();
            if ($status != 0) {
                Moony_Utils::sendStatus($status);
            }

            // HTTPヘッダ送出
            $headers = $response->getHeaders();
            foreach ($headers as $header) {
                header("${header}");
            }

            // 添付ファイルが設定されている場合、
            // 添付ファイルダウンロード（画面遷移しない）
            $file = $response->getAttachmentFile();
            if (count($file) > 0 && strlen($file[0]) > 0) {
                Moony_Downloader::download($file[0], $file[1]);
                exit(0);
            }

            // リダイレクト先が設定されている場合、リダイレクト
            $redirect_url = $response->getRedirectUrl();
            if (strlen($redirect_url) > 0) {
                Moony_Utils::sendStatus(302);
                Moony_Utils::redirect($redirect_url);
                exit(0);
            }

            // 設定値取得、Viewに設定
            $attributes = $response->getAttributes();
            $view->assign($attributes);

            // キャッシュ設定取得、設定に応じてキャッシュ
            if ($response->cache()) {
                $view->caching = 1;
            }

            // テンプレート名称取得
            $template = $response->getTemplate();

        } else {
            // アクションクラスが存在しない場合、設定に応じてキャッシュ
            if (MOONY_SMARTY_USE_CACHE_WITHOUT_ACTION) {
                $view->caching = 1;
            }
        }

        // 画面表示
        $view->render($template);
    }
}
?>
