<?php
/**
 * テンプレートを操作するためのクラスです。
 * Smartyのサブクラスとして実装されています。
 * 
 * @package Moony
 * @subpackage core
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_View extends Smarty
{
    /**
     * コンストラクタです。singletonとして扱うため、
     * 直接呼び出さずにgetInstanceメソッドを使用してください。
     *
     * @access private
     */
    function Moony_View()
    {
        $this->Smarty();

        $this->template_dir = MOONY_SMARTY_TEMPLATE_DIR;
        $this->compile_dir = MOONY_SMARTY_COMPILE_DIR;

        // エンコーディングが異なっている場合にフィルタ
        if (MOONY_TEMPLATE_ENCODING != MOONY_INTERNAL_ENCODING) {
            $this->register_prefilter(array(&$this, 'prefilter'));
        }
        if (MOONY_OUTPUT_ENCODING != MOONY_INTERNAL_ENCODING) {
            $this->register_outputfilter(array(&$this, 'outputFilter'));
        }

        // 任意の設定がなされていた場合
        if (defined('MOONY_SMARTY_CACHE_DIR')) {
            $this->cache_dir = MOONY_SMARTY_CACHE_DIR;
        }
        if (defined('MOONY_SMARTY_CONFIG_DIR')) {
            $this->config_dir = MOONY_SMARTY_CONFIG_DIR;
        }
        if (defined('MOONY_SMARTY_COMPILE_CHECK')) {
            $this->compile_check = MOONY_SMARTY_COMPILE_CHECK;
        }
        if (defined('MOONY_SMARTY_FORCE_COMPILE')) {
            $this->force_compile = MOONY_SMARTY_FORCE_COMPILE;
        }
        if (defined('MOONY_SMARTY_DEFAULT_MODIFIERS')) {
            $this->default_modifiers = MOONY_SMARTY_DEFAULT_MODIFIERS;
        }
    }

    /**
     * singletonインスタンスを返します。
     *
     * @access public
     * @static
     * @return object Moony_Viewのsingletonインスタンス
     */
    function &getInstance()
    {
        static $instance;
        if (is_null($instance)) {
            $instance =& new Moony_View();
        }
        return $instance;
    }

    /**
     * 指定されたテンプレートを利用して、
     * 画面描画処理を行います。
     * 
     * @access public
     * @param string $template テンプレートファイル名
     */
    function render($template)
    {
        $path = Moony_Utils::buildPath($this->template_dir, $template);
        if (!file_exists($path)) {
            Moony_Logger::warn('Template file not found: ' . $path, __FILE__, __LINE__);
            Moony_Error::notFound();
            exit(1);
        }
        if (MOONY_SENDING_HEADER_ABOUT_ENCODING) {
            $encoding = MOONY_OUTPUT_ENCODING;
            if (MOONY_OUTPUT_ENCODING == 'SJIS') {
                $encoding = 'Shift_JIS';
            }
            if (MOONY_USE_XHTML_HEADER) {
                header("Content-Type: application/xhtml+xml; charset=${encoding}");
            } else {
                header("Content-Type: text/html; charset=${encoding}");
            }
        }
        $this->display($template);
    }

    /**
     * Smartyで使用されるプリフィルタです。
     *
     * @access public
     * @param string $src テンプレートファイルの内容
     * @param object &$smarty Smartyのインスタンス
     */
    function prefilter($src, &$smarty)
    {
        return mb_convert_encoding($src, MOONY_INTERNAL_ENCODING, MOONY_TEMPLATE_ENCODING);
    }

    /**
     * Smartyで使用される出力フィルタです。
     *
     * @access public
     * @param string $src テンプレートファイルの内容
     * @param object &$smarty Smartyのインスタンス
     */
    function outputFilter($src, &$smarty)
    {
        return mb_convert_encoding($src, MOONY_OUTPUT_ENCODING, MOONY_INTERNAL_ENCODING);
    }
}
?>
