<?php
/**
 * Moonyで使用されるアクションクラス、
 * テンプレートファイルの自動生成を行います。
 * 
 * @package Moony
 * @subpackage util
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */

if ($_SERVER['argc'] != 4) {
    $error_message = "Parameter Error...\n";
    $error_message .= "usage: /path/to/php Moony_Codegen.php [action_name] [action_dir] [template_dir]\n";
    die($error_message);
}

$action_name = $_SERVER['argv'][1];
$action_dir = $_SERVER['argv'][2];
$template_dir = $_SERVER['argv'][3];

$root_dir = dirname(dirname(__FILE__));
require_once $root_dir . '/Moony_Config.php';

$action_file = $action_dir . '/' . $action_name . 'Action.' . MOONY_ACTION_EXT;
$template_file = $template_dir . '/' . $action_name . '.' . MOONY_SMARTY_TEMPLATE_EXT;

if (file_exists($action_file)) {
    die("Error: Action class file already exists\n");
}
if (file_exists($template_file)) {
    die("Error: Template file already exists\n");
}

$action_tpl = <<<_ACTION_TPL_END
<?php
class %s extends Moony_Action
{
    function execute(\$request, \$response)
    {
    }
}
?>

_ACTION_TPL_END;

$template_tpl = <<<_TEMPLATE_TPL_END
<html>

<head>
</head>

<body>
</body>

</html>

_TEMPLATE_TPL_END;

$action_content = sprintf($action_tpl, $action_name . 'Action');
$template_content = sprintf($template_tpl, $action_name);

$fp = fopen($action_file, 'w');
fputs($fp, $action_content);
fclose($fp);

$fp = fopen($template_file, 'w');
fputs($fp, $template_content);
fclose($fp);

echo "Skelton for '$action_name' successfully generated!\n";
?>
