<?php
/**
 * ファイルのダウンロードを行うためのクラスです。
 * 
 * @package Moony
 * @subpackage util
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @license http://www.opensource.org/licenses/bsd-license.php The BSD License
 */
class Moony_Downloader
{
    /**
     * 指定されたファイルをhttpレスポンスに添付します。
     *
     * @access public
     * @static
     * @param string $file 添付するファイルのパス
     * @param string $name 添付するファイルにつける名前
     */
    function download($file, $name = null)
    {
        $error = false;
        if (!file_exists($file)) {
            Moony_Logger::warn('File not found: ' . $file, __FILE__, __LINE__);
            $error = true;
        }
        if (!($fp = fopen($file, 'r'))) {
            Moony_Logger::warn('Unable to open file: ' . $file, __FILE__, __LINE__);
            $error = true;
        }
        fclose($fp);
        if (($size = filesize($file)) == 0) {
            Moony_Logger::warn('File size=0: ' . $file, __FILE__, __LINE__);
            $error = true;
        }
        if ($error) {
            Moony_Error::notFound();
            exit(1);
        }

        if (strlen($name) == 0) {
            $name = basename($file);
        }

        header("Content-Disposition: attachment; filename=\"${name}\"");
        header("Content-Length: ${size}");
        header('Content-Type: application/octet-stream');

        if (!readfile($file)) {
            Moony_Logger::warn('Unable to read file: ' . $file, __FILE__, __LINE__);
            Moony_Error::notFound();
            exit(1);
        }
    }
}
?>
