<?php
/**
 * Moony - the tiny web application framework
 *
 * @package   Moony
 * @author    YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @link      http://moony.sourceforge.jp/
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license   http://opensource.org/licenses/bsd-license.php The BSD License
 */

/**
 * リクエストパラメータの変換を行うクラスです。
 *
 * @package Moony
 * @author YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @access public
 */
class Moony_Converter
{
    /**
     * 内部エンコーディング
     * @var string
     */
    var $_internal_encoding;

    /**
     * コンストラクタです。
     *
     * @access public
     * @param string $internal_encoding 内部エンコーディング
     */
    function Moony_Converter($internal_encoding)
    {
        $this->_internal_encoding = $internal_encoding;
    }

    /**
     * 「trim」関数を用いて値の両端の空白文字を除去します。
     *
     * @access public
     * @param string|array $value 処理対象値
     * @param string $charlist 除去される文字
     */
    function trim(&$value, $charlist = null)
    {
        if (is_null($charlist)) {
            $value = is_array($value) ?
                array_map('trim', $value) : trim($value);
        } else {
            if (is_array($value)) {
                $count = count($value);
                for ($i = 0; $i < $count; $i++) {
                    $value[$i] = trim($value[$i], $charlist);
                }
            } else {
                $value = trim($value, $charlist);
            }
        }
    }

    /**
     * 「intval」関数を用いて10進数の整数としての値に変換します。
     *
     * @access public
     * @param stirng|array $value 処理対象値
     */
    function toInt(&$value)
    {
        if (is_array($value)) {
            $value = array_map('intval', $value);
        } else {
            $value = intval($value);
        }
    }

    /**
     * 「floatval」関数を用いてfloat値に変換します。
     *
     * @access public
     * @param string|array $value 処理対象値
     */
    function toFloat(&$value)
    {
        if (is_array($value)) {
            $value = array_map('floatval', $value);
        } else {
            $value = floatval($value);
        }
    }

    /**
     * 大文字にします。
     *
     * @access public
     * @param string|array $value 処理対象値
     */
    function toUppercase(&$value)
    {
        if (is_array($value)) {
            $value = array_map('strtoupper', $value);
        } else {
            $value = strtoupper($value);
        }
    }

    /**
     * 小文字にします。
     *
     * @access public
     * @param string|array $value 処理対象値
     */
    function toLowercase(&$value)
    {
        if (is_array($value)) {
            $value = array_map('strtolower', $value);
        } else {
            $value = strtolower($value);
        }
    }

    /**
     * ひらがなに変換します。
     * 「mb_convert_kana」関数を使用します。
     *
     * @access public
     * @param string|array $value 処理対象値
     */
    function toHiragana(&$value)
    {
        $this->toKana($value, 'HVc');
    }

    /**
     * カタカナ（全角）に変換します。
     * 「mb_convert_kana」関数を使用します。
     *
     * @access public
     * @param string|array $value 処理対象値
     */
    function toKatakana(&$value)
    {
        $this->toKana($value, 'KVC');
    }

    /**
     * 英数字を半角にします。
     * 「mb_convert_kana」関数を使用します。
     *
     * @access public
     * @param string|array $value 処理対象値
     */
    function toHalfWidth(&$value)
    {
        $this->toKana($value, 'a');
    }

    /**
     * 「mb_convert_kana」関数を使用した変換を行います。
     *
     * @access public
     * @param string|array $value 処理対象値
     * @param string $option 変換オプション
     */
    function toKana(&$value, $option)
    {
        if (is_array($value)) {
            $count = count($value);
            for ($i = 0; $i < $count; $i++) {
                $value[$i] = mb_convert_kana(
                    $value[$i], $option, $this->_internal_encoding);
            }
        } else {
            $value = mb_convert_kana(
                $value, $option, $this->_internal_encoding);
        }
    }
}
?>
