<?php
/**
 * Moony - the tiny web application framework
 *
 * @package   Moony
 * @author    YAMAOKA Hiroyuki <yamaoka@catwalker.jp>
 * @link      http://moony.sourceforge.jp/
 * @copyright 2005-2006 YAMAOKA Hiroyuki
 * @license   http://opensource.org/licenses/bsd-license.php The BSD License
 */

/**
 * hiddenフィールドとしてトランザクショントークンを出力するヘルパー関数です。
 * テンプレート内部で使用されます。
 * （例: <?php moony_token(); ?>）
 *
 * @access public
 * @param bool $xhtml XHTMLのフォーマットで描画するかどうか
 */
function moony_token($xhtml = true)
{
    $close_tag = $xhtml ? ' />' : '>';
    if (isset($_SESSION[MOONY_TOKEN_KEY])) {
        $token = $_SESSION[MOONY_TOKEN_KEY];
        echo '<input type="hidden" name="' .
            MOONY_TOKEN_KEY . '" value="', $token, '"', $close_tag, "\n";
    }
}

/**
 * 別のテンプレートファイルを読み込んで表示するヘルパー関数です。
 * 該当のテンプレートファイルが存在しない場合、何も処理しません。
 * テンプレート内部で使用されます。
 * （例: <?php moony_include('foo.php'); ?>）
 *
 * @access public
 * @param string $template 読み込むテンプレートファイル名
 */
function moony_include($template)
{
    $action =& $GLOBALS[MOONY_ACTION_KEY];
    $result = $action->fetch($template);
    if ($result !== false) {
        echo $result;
    }
}

/**
 * 全ての検証エラーメッセージを表示するヘルパー関数です。
 * エラーメッセージが設定されていない場合、何も処理しません。
 * テンプレート内部で使用されます。
 * （例: <?php moony_errors(); ?>）
 *
 * @access public
 * @param string $header 全体のヘッダ
 * @param string $footer 全体のフッタ
 * @param string $prefix 個々のメッセージの接頭辞
 * @param string $postfix 個々のメッセージの接尾辞
 */
function moony_errors($header = '<ul>',
    $footer = '</ul>', $prefix = '<li>', $postfix = '</li>')
{
    if (isset($GLOBALS[MOONY_VALIDATOR_KEY])) {
        $validator =& $GLOBALS[MOONY_VALIDATOR_KEY];
        $error_messages = $validator->getErrorMessages();
        echo $header;
        foreach ($error_messages as $error_message) {
            echo $prefix, $error_message, $postfix;
        }
        echo $footer;
    }
}

/**
 * 検証エラーの有無を判断するヘルパー関数です。
 * テンプレート内部で使用されます。
 * （例: <?php if (moony_has_error()): ?>）
 *
 * @access public
 * @return bool 検証エラーの存在有無
 */
function moony_has_error()
{
    if (isset($GLOBALS[MOONY_VALIDATOR_KEY])) {
        $validator =& $GLOBALS[MOONY_VALIDATOR_KEY];
        return $validator->hasError();
    }
    return false;
}

/**
 * 文字列をエスケープした上で出力するヘルパー関数です。
 * テンプレート内部で使用されます。
 * （例: <?php h($this->foo); ?>）
 *
 * @access public
 * @param string $string 出力したい文字列
 */
function h($string)
{
    if (!is_null($string)) {
        echo htmlspecialchars($string, ENT_QUOTES);
    }
}
?>
