<?php
class Moony_RequestTest extends UnitTestCase
{
    var $req;
    var $userfile;

    function setUp()
    {
        $this->userfile = array(
            'name' => 'a.txt',
            'type' => 'text/plain',
            'size' => 32,
            'tmp_name' => 'opqrstu',
            'error' => UPLOAD_ERR_OK
        );

        $_POST = array('foo' => 'a', 'bar' => 'bb');
        $_GET = array('foo' => 'A', 'baz' => 'CCC');
        $_FILES = array('userfile' => $this->userfile);
        $_SERVER['QUERY_STRING'] = 'sss';
        $this->req =& new Moony_Request();
    }

    function testGet()
    {
        $this->assertEqual('a', $this->req->get('foo'));
        $this->assertEqual('AAA', $this->req->get('fooo', 'AAA'));
        $this->assertNull($this->req->get('barrrr'));
        $this->assertEqual('CCC', $this->req->get('baz'));

        $expected = array('foo' => 'a', 'bar' => 'bb', 'baz' => 'CCC');
        $this->assertEqual($expected, $this->req->get());
    }

    function testExists()
    {
        $this->assertTrue($this->req->exists('foo'));
        $this->assertFalse($this->req->exists('fooo'));
    }

    function testGetFile()
    {
        $this->assertEqual($this->userfile, $this->req->getFile('userfile'));
        $this->assertNull($this->req->getFile('non-userfile'));
    }

    function testGetQueryString()
    {
        $this->assertEqual('sss', $this->req->getQueryString());
    }

    function testGetEnv()
    {
        $_SERVER['REQUEST_URI'] = '/foo.php';
        $this->assertEqual('/foo.php', $this->req->getEnv('REQUEST_URI'));
        $_SERVER['REQUEST_URI'] = "\0/foo.\0php";
        $this->assertEqual('/foo.php', $this->req->getEnv('REQUEST_URI'));
    }

    function testGetHeader()
    {
        $_SERVER['HTTP_USER_AGENT'] = 'Mozilla';
        $this->assertEqual('Mozilla', $this->req->getHeader('User-Agent'));
    }

    function testIsPost()
    {
        $_SERVER['REQUEST_METHOD'] = 'POST';
        $req1 =& new Moony_Request();
        $this->assertTrue($req1->isPost());
        $_SERVER['REQUEST_METHOD'] = 'GET';
        $req1 =& new Moony_Request();
        $this->assertFalse($req1->isPost());
    }

    function testIsGet()
    {
        $_SERVER['REQUEST_METHOD'] = 'GET';
        $req1 =& new Moony_Request();
        $this->assertTrue($req1->isGet());
        $_SERVER['REQUEST_METHOD'] = 'POST';
        $req1 =& new Moony_Request();
        $this->assertFalse($req1->isGet());
    }

    function testIsPut()
    {
        $_SERVER['REQUEST_METHOD'] = 'PUT';
        $req1 =& new Moony_Request();
        $this->assertTrue($req1->isPut());
        $_SERVER['REQUEST_METHOD'] = 'GET';
        $req1 =& new Moony_Request();
        $this->assertFalse($req1->isPut());
    }

    function testIsDelete()
    {
        $_SERVER['REQUEST_METHOD'] = 'DELETE';
        $req1 =& new Moony_Request();
        $this->assertTrue($req1->isDelete());
        $_SERVER['REQUEST_METHOD'] = 'GET';
        $req1 =& new Moony_Request();
        $this->assertFalse($req1->isDelete());
    }

    function testIsHead()
    {
        $_SERVER['REQUEST_METHOD'] = 'HEAD';
        $req1 =& new Moony_Request();
        $this->assertTrue($req1->isHead());
        $_SERVER['REQUEST_METHOD'] = 'GET';
        $req1 =& new Moony_Request();
        $this->assertFalse($req1->isHead());
    }

    function testIsSsl()
    {
        $_SERVER['HTTPS'] = 'on';
        $this->assertTrue($this->req->isSsl());
        unset($_SERVER['HTTPS']);
        $this->assertFalse($this->req->isSsl());
    }

    function testIsXmlHttpRequest()
    {
        $_SERVER['HTTP_X_REQUESTED_WITH'] = 'XMLHttpRequest';
        $this->assertTrue($this->req->isXmlHttpRequest());
        $_SERVER['HTTP_X_REQUESTED_WITH'] = 'foo';
        $this->assertFalse($this->req->isXmlHttpRequest());
        unset($_SERVER['HTTP_X_REQUESTED_WITH']);
        $this->assertFalse($this->req->isXmlHttpRequest());
    }

    function testIsXhr()
    {
        $_SERVER['HTTP_X_REQUESTED_WITH'] = 'XMLHttpRequest';
        $this->assertTrue($this->req->isXhr());
        $_SERVER['HTTP_X_REQUESTED_WITH'] = 'foo';
        $this->assertFalse($this->req->isXhr());
        unset($_SERVER['HTTP_X_REQUESTED_WITH']);
        $this->assertFalse($this->req->isXhr());
    }

    function testConvertEncoding()
    {
        // TODO creates test cases
    }

    function test_Filter()
    {
        $value = "\0abcdef\0";
        $this->assertEqual('abcdef', $this->req->_filter($value));
    }

}
?>
