<?php
class MoonyTest extends UnitTestCase
{
    var $moony;

    function setUp()
    {
        $this->moony =& new Moony();
    }

    function testSetActionDir()
    {
        $this->assertEqual('actions', $this->moony->action_dir);
        $this->moony->setActionDir('/path/to/actions');
        $this->assertEqual('/path/to/actions', $this->moony->action_dir);
        $this->moony->setActionDir('/path/to/actions/');
        $this->assertEqual('/path/to/actions', $this->moony->action_dir);
    }

    function testSetTemplateDir()
    {
        $this->assertEqual('templates', $this->moony->template_dir);
        $this->moony->setTemplateDir('/path/to/tesmplates');
        $this->assertEqual('/path/to/tesmplates', $this->moony->template_dir);
        $this->moony->setTemplateDir('/path/to/tesmplates/');
        $this->assertEqual('/path/to/tesmplates', $this->moony->template_dir);
    }

    function testSetInputEncoding()
    {
        $this->assertNull($this->moony->input_encoding);
        $this->moony->setInputEncoding('SJIS-win');
        $this->assertEqual('SJIS-win', $this->moony->input_encoding);
    }

    function testSetOutputEncoding()
    {
        $this->assertNull($this->moony->output_encoding);
        $this->moony->setOutputEncoding('SJIS-win');
        $this->assertEqual('SJIS-win', $this->moony->output_encoding);
    }

    function testSetInternalEncoding()
    {
        $this->assertNull($this->moony->internal_encoding);
        $this->moony->setInternalEncoding('UTF-8');
        $this->assertEqual('UTF-8', $this->moony->internal_encoding);
    }

    function testSetDefaultAction()
    {
        $this->assertNull($this->moony->default_action_name);
        $this->moony->setDefaultAction('Foo_Bar');
        $this->assertEqual('Foo_Bar', $this->moony->default_action_name);
    }

    function testSetDefaultRedirect()
    {
        $this->assertNull($this->moony->default_redirect_url);
        $this->moony->setDefaultRedirect('http://example.com/');
        $this->assertEqual('http://example.com/', $this->moony->default_redirect_url);
    }

    function testSetSessionAutoStart()
    {
        $this->assertTrue($this->moony->session_auto_start);
        $this->moony->setSessionAutoStart(false);
        $this->assertFalse($this->moony->session_auto_start);
        $this->moony->setSessionAutoStart(true);
        $this->assertTrue($this->moony->session_auto_start);
    }
}
?>
