<?php
// ignores E_NOTICE
error_reporting(E_ALL ^ E_NOTICE);
mb_internal_encoding('UTF-8');

define('SIMPLE_TEST_DIR', 'Pearified/Testing/SimpleTest/');
define('MOONY_TEST_DIR', dirname(__FILE__));

// unit test with simpletest
require_once SIMPLE_TEST_DIR . 'unit_tester.php';
require_once SIMPLE_TEST_DIR . 'reporter.php';

// loads Moony.php
$moony_path = dirname(dirname(__FILE__)) . DIRECTORY_SEPARATOR . 'Moony.php';
if (file_exists($moony_path)) {
    require_once $moony_path;
} else {
    // installed with PEAR
    require_once 'Moony.php';
}
require_once MOONY_ROOT_DIR . '/Moony/Converter.php';
require_once MOONY_ROOT_DIR . '/Moony/Request.php';
require_once MOONY_ROOT_DIR . '/Moony/Validator.php';

// grouping
$test =& new GroupTest('All tests');

// add test files
$test->addTestFile(MOONY_TEST_DIR . '/MoonyTest.php');
$test->addTestFile(MOONY_TEST_DIR . '/Moony/ConverterTest.php');
$test->addTestFile(MOONY_TEST_DIR . '/Moony/RequestTest.php');
$test->addTestFile(MOONY_TEST_DIR . '/Moony/ValidatorTest.php');

$reporter = TextReporter::inCli() ? 'TextReporter' : 'HtmlReporter';
$test->run(new $reporter);
?>
