/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.handlers;

import jp.sourceforge.moreemacs.handlers.TextEditorExecution;
import jp.sourceforge.moreemacs.utils.CodePointIterator;
import jp.sourceforge.moreemacs.utils.DocumentCharSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public final class KillLineExecution
extends TextEditorExecution {
    @Override
    public void execute() throws BadLocationException {
        if (!this.textEditor.isEditable()) {
            return;
        }
        int current = this.cursor.offset();
        int linePos = this.doc.getLineOfOffset(current);
        IRegion line = this.doc.getLineInformation(linePos);
        String delim = this.doc.getLineDelimiter(linePos);
        int length = line.getOffset() + line.getLength() - current;
        boolean allSpaces = this.isAllSpaces(this.doc, current, length);
        int cutLength = length;
        if (allSpaces && delim != null) {
            cutLength += delim.length();
        }
        String cut = this.doc.get(current, cutLength);
        Clipboard c = new Clipboard(this.window.getShell().getDisplay());
        c.setContents((Object[])new String[]{cut}, new Transfer[]{TextTransfer.getInstance()});
        this.doc.replace(current, cutLength, "");
    }

    private boolean isAllSpaces(IDocument doc, int offset, int length) throws BadLocationException {
        DocumentCharSequence seq = new DocumentCharSequence(doc, offset, length);
        for (int codePoint : CodePointIterator.each(seq)) {
            if (Character.isWhitespace(codePoint)) continue;
            return false;
        }
        return true;
    }
}

