/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.handlers;

import jp.sourceforge.moreemacs.handlers.Cursor;
import jp.sourceforge.moreemacs.handlers.Execution;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

abstract class TextEditorExecution
implements Execution {
    protected IWorkbenchWindow window;
    protected ITextEditor textEditor;
    protected ITextViewer textViewer;
    protected Cursor cursor;
    protected IDocument doc;

    TextEditorExecution() {
    }

    @Override
    public boolean init(IWorkbenchWindow window) {
        this.window = window;
        IEditorPart editor = window.getActivePage().getActiveEditor();
        this.textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
        if (this.textEditor == null) {
            return false;
        }
        this.doc = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (!(target instanceof ITextViewer)) {
            return false;
        }
        this.textViewer = (ITextViewer)target;
        this.cursor = new Cursor(this.textEditor, this.textViewer);
        return true;
    }

    protected ITextSelection getSelection(boolean fallbackToMark) {
        ITextSelection selection = (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
        if (!fallbackToMark && selection.getLength() != 0) {
            return selection;
        }
        IEditorPart editor = this.window.getActivePage().getActiveEditor();
        ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (!(target instanceof ITextViewerExtension)) {
            return selection;
        }
        ITextViewerExtension viewerEx = (ITextViewerExtension)target;
        int mark = viewerEx.getMark();
        if (mark == -1) {
            return selection;
        }
        int current = selection.getOffset();
        int start = mark < current ? mark : current;
        this.textViewer.setSelectedRange(start, Math.abs(mark - current));
        return (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
    }

    protected final int getTabStop() {
        return this.textViewer.getTextWidget().getTabs();
    }
}

