/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.moreemacs.handlers;

import jp.sourceforge.moreemacs.handlers.TextEditorExecution;
import jp.sourceforge.moreemacs.utils.DocumentCharSequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

public final class TransposeCharsExecution
extends TextEditorExecution {
    @Override
    public void execute() throws BadLocationException {
        if (!this.textEditor.isEditable()) {
            return;
        }
        int current = this.cursor.offset();
        if (current == 0) {
            return;
        }
        int linePos = this.doc.getLineOfOffset(current);
        IRegion line = this.doc.getLineInformation(linePos);
        DocumentCharSequence seq = new DocumentCharSequence(this.doc);
        if (line.getOffset() + line.getLength() == current) {
            current = line.getOffset() == current ? current - this.doc.getLineDelimiter(linePos - 1).length() : seq.previousCodePointIndex(current);
            linePos = this.doc.getLineOfOffset(current);
            line = this.doc.getLineInformation(linePos);
        }
        if (current == 0) {
            return;
        }
        int nextIndex = seq.nextCodePointIndex(current);
        String forwardChars = line.getOffset() + line.getLength() == current ? this.doc.getLineDelimiter(linePos) : this.doc.get(current, nextIndex - current);
        int prevIndex = seq.previousCodePointIndex(current);
        String backwardChars = line.getOffset() == current ? this.doc.getLineDelimiter(linePos - 1) : this.doc.get(prevIndex, current - prevIndex);
        this.doc.replace(current - backwardChars.length(), backwardChars.length() + forwardChars.length(), String.valueOf(forwardChars) + backwardChars);
    }
}

