/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExpandedInputStream
extends BufferedInputStream {
    public ExpandedInputStream(InputStream in) {
        super(in);
    }

    public ExpandedInputStream(InputStream in, int size) {
        super(in, size);
    }

    public synchronized byte[] readAll() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeTo(out);
        return out.toByteArray();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        byte[] b = new byte[this.buf.length];
        int len = 0;
        while ((len = this.read(b, 0, b.length)) != -1) {
            out.write(b, 0, len);
        }
    }

    public static synchronized ExpandedInputStream valueOf(InputStream in) {
        if (in instanceof ExpandedInputStream) {
            return (ExpandedInputStream)in;
        }
        return new ExpandedInputStream(in);
    }
}

