/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.server;

import jp.morpho.lang.LifeCycleException;
import jp.morpho.lang.LifeCycleThread;

public abstract class ThreadServer
implements LifeCycleThread {
    protected Thread _thread = null;
    protected boolean _daemon = false;
    protected boolean _running = false;
    protected boolean _shutdown = false;

    public ThreadServer() {
        this(true);
    }

    public ThreadServer(boolean daemon) {
        this._daemon = daemon;
    }

    public synchronized boolean isRunning() {
        return this._running;
    }

    public synchronized boolean isShutdown() {
        return this._shutdown;
    }

    public synchronized void start() throws LifeCycleException {
        if (this._running) {
            throw new LifeCycleException("Already started");
        }
        this._thread = new Thread(this);
        this._thread.setDaemon(this._daemon);
        this._thread.start();
        this._shutdown = false;
        this._running = true;
    }

    public synchronized void stop() throws LifeCycleException {
        this._shutdown = true;
    }

    public void run() {
        this._running = false;
    }

    public final void join() throws InterruptedException {
        if (this._thread == null) {
            return;
        }
        this._thread.join();
    }
}

