/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractComparableFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class ByteValidator
extends AbstractComparableFieldValidator {
    private Byte minimum = null;
    private Byte maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        byte number = 0;
        try {
            number = Byte.parseByte(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not byte");
        }
        if (this.minimum != null && this.minimum > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < number) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            byte compareValue = Byte.parseByte(this.getFieldValueAsString(request, this.getCompareFieldName()));
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (number <= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (number < compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (number > compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (number >= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(byte value) {
        this.minimum = new Byte(value);
    }

    public void setMaximum(byte value) {
        this.maximum = new Byte(value);
    }

    public byte getMaximum() {
        return this.maximum != null ? this.maximum : (byte)0;
    }

    public byte getMinimum() {
        return this.minimum != null ? this.minimum : (byte)0;
    }

    public boolean isMaximumSet() {
        return this.maximum != null;
    }

    public boolean isMinimumSet() {
        return this.minimum != null;
    }
}

