/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractComparableFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class DateValidator
extends AbstractComparableFieldValidator {
    private String pattern = null;
    private Locale locale = null;
    private Date minimum = null;
    private Date maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        if (this.pattern == null) {
            throw new ValidationException("pattern is not set");
        }
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        SimpleDateFormat dateFormat = null;
        dateFormat = this.locale == null ? new SimpleDateFormat(this.pattern) : new SimpleDateFormat(this.pattern, this.locale);
        Date date = null;
        try {
            date = dateFormat.parse(value);
            if (date == null) {
                throw new ValidationException("value is not date");
            }
        }
        catch (Exception e) {
            throw new ValidationException("value is not date");
        }
        if (this.minimum != null && this.minimum.compareTo(date) < 0) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum.compareTo(date) > 0) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            Date compareValue = null;
            try {
                compareValue = new SimpleDateFormat(this.pattern).parse(this.getFieldValueAsString(request, this.getCompareFieldName()));
            }
            catch (Exception e) {
                throw new ValidationException(e.getMessage());
            }
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">") ? date.compareTo(compareValue) <= 0 : (ope.equals(">=") ? date.compareTo(compareValue) < 0 : (ope.equals("==") ? date.compareTo(compareValue) != 0 : (ope.equals("<=") ? date.compareTo(compareValue) > 0 : (ope.equals("<") ? date.compareTo(compareValue) >= 0 : ope.equals("!=") && date.compareTo(compareValue) == 0))))) {
                throw new ValidationException("compare error");
            }
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String value) {
        this.pattern = value;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMinimum(Date value) {
        this.minimum = value;
    }

    public void setMaximum(Date value) {
        this.maximum = value;
    }

    public Date getMaximum() {
        return this.maximum;
    }

    public Date getMinimum() {
        return this.minimum;
    }
}

