/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractComparableFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class IntegerValidator
extends AbstractComparableFieldValidator {
    private Integer minimum = null;
    private Integer maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        int number = 0;
        try {
            number = Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not int");
        }
        if (this.minimum != null && this.minimum > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < number) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            int compareValue = Integer.parseInt(this.getFieldValueAsString(request, this.getCompareFieldName()));
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (number <= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (number < compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (number > compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (number >= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(int value) {
        this.minimum = new Integer(value);
    }

    public void setMaximum(int value) {
        this.maximum = new Integer(value);
    }

    public int getMaximum() {
        return this.maximum != null ? this.maximum : 0;
    }

    public int getMinimum() {
        return this.minimum != null ? this.minimum : 0;
    }

    public boolean isMaximumSet() {
        return this.maximum != null;
    }

    public boolean isMinimumSet() {
        return this.minimum != null;
    }
}

