/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.LengthValidator;
import jp.morpho.webapp.validator.ValidationException;

public class RegexValidator
extends LengthValidator {
    private String pattern = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        if (this.pattern == null) {
            throw new ValidationException("pattern is not set");
        }
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        try {
            Pattern p = Pattern.compile(this.pattern);
            Matcher m = p.matcher(value);
            if (!m.find()) {
                throw new ValidationException("value is not match");
            }
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        super.validate(request);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String value) {
        this.pattern = value;
    }
}

