/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.validator;

import jp.morpho.webapp.servlet.http.HttpActionRequest;
import jp.morpho.webapp.validator.AbstractComparableFieldValidator;
import jp.morpho.webapp.validator.ValidationException;

public class ShortValidator
extends AbstractComparableFieldValidator {
    private Short minimum = null;
    private Short maximum = null;

    public void validate(HttpActionRequest request) throws ValidationException {
        String value = this.getFieldValueAsString(request);
        if (!this.isValidate(value)) {
            return;
        }
        this.validateRequired(value);
        short number = 0;
        try {
            number = Short.parseShort(value);
        }
        catch (Exception e) {
            throw new ValidationException("value is not short");
        }
        if (this.minimum != null && this.minimum > number) {
            throw new ValidationException("out of range");
        }
        if (this.maximum != null && this.maximum < number) {
            throw new ValidationException("out of range");
        }
        if (this.getCompareFieldName() != null) {
            if (this.getCompareOperator() == null) {
                throw new ValidationException("compare operator is not set");
            }
            short compareValue = Short.parseShort(this.getFieldValueAsString(request, this.getCompareFieldName()));
            String ope = this.getCompareOperator().trim();
            if (ope.equals(">")) {
                if (number <= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals(">=")) {
                if (number < compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("==")) {
                if (number != compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<=")) {
                if (number > compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("<")) {
                if (number >= compareValue) {
                    throw new ValidationException("compare error");
                }
            } else if (ope.equals("!=")) {
                if (number == compareValue) {
                    throw new ValidationException("compare error");
                }
            } else {
                throw new ValidationException("compare operator is not supported:" + ope);
            }
        }
    }

    public void setMinimum(short value) {
        this.minimum = new Short(value);
    }

    public void setMaximum(short value) {
        this.maximum = new Short(value);
    }

    public short getMaximum() {
        return this.maximum != null ? this.maximum : (short)0;
    }

    public short getMinimum() {
        return this.minimum != null ? this.minimum : (short)0;
    }

    public boolean isMaximumSet() {
        return this.maximum != null;
    }

    public boolean isMinimumSet() {
        return this.minimum != null;
    }
}

