/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.platform.entity;

import java.util.Date;
import java.util.List;

import jp.mosp.platform.dto.human.ConcurrentDtoInterface;
import jp.mosp.platform.dto.human.EntranceDtoInterface;
import jp.mosp.platform.dto.human.HumanDtoInterface;
import jp.mosp.platform.dto.human.RetirementDtoInterface;
import jp.mosp.platform.dto.human.SuspensionDtoInterface;
import jp.mosp.platform.dto.system.EmploymentContractDtoInterface;
import jp.mosp.platform.dto.system.PositionDtoInterface;
import jp.mosp.platform.dto.system.SectionDtoInterface;

/**
 * 社員情報インターフェース
 */
public interface EmployeeEntityInterface {
	
	/**
	 * @return 有効日。
	 */
	Date getActivateDate();
	
	/**
	 * @return 個人ID。
	 */
	String getPersonalId();
	
	/**
	 * @return 社員コード。
	 */
	String getEmployeeCode();
	
	/**
	 * @return 休退職区分。
	 */
	String getStateType();
	
	/**
	 * @return 休退職区分名称。
	 */
	String getStateName();
	
	/**
	 * @return 人事マスタ。
	 */
	HumanDtoInterface getHumanDto();
	
	/**
	 * @return 所属マスタ。
	 */
	SectionDtoInterface getSectionDto();
	
	/**
	 * @return 職位マスタ。
	 */
	PositionDtoInterface getPositionDto();
	
	/**
	 * @return 雇用契約マスタ。
	 */
	EmploymentContractDtoInterface getEmploymentContractDto();
	
	/**
	 * @return 人事入社情報。
	 */
	EntranceDtoInterface getEntranceDto();
	
	/**
	 * @return 人事休職情報。
	 */
	SuspensionDtoInterface getSuspensionDto();
	
	/**
	 * @return 人事退職情報。
	 */
	RetirementDtoInterface getRetirementDto();
	
	/**
	 * @return 人事兼務情報。
	 */
	List<ConcurrentDtoInterface> getConcurrentList();
	
	/**
	 * @param activateDate セットする 有効日。
	 */
	void setActivateDate(Date activateDate);
	
	/**
	 * @param personalId セットする 個人ID。
	 */
	void setPersonalId(String personalId);
	
	/**
	 * @param employeeCode セットする 社員コード。
	 */
	void setEmployeeCode(String employeeCode);
	
	/**
	 * @param stateType セットする 休退職区分。
	 */
	void setStateType(String stateType);
	
	/**
	 * @param stateName セットする 休退職区分名称。
	 */
	void setStateName(String stateName);
	
	/**
	 * @param humanDto セットする 人事マスタ。
	 */
	void setHumanDto(HumanDtoInterface humanDto);
	
	/**
	 * @param sectionDto セットする 所属マスタ。
	 */
	void setSectionDto(SectionDtoInterface sectionDto);
	
	/**
	 * @param positionDto セットする 職位マスタ。
	 */
	void setPositionDto(PositionDtoInterface positionDto);
	
	/**
	 * @param employmentContractDto セットする 雇用契約マスタ。
	 */
	void setEmploymentContractDto(EmploymentContractDtoInterface employmentContractDto);
	
	/**
	 * @param entranceDto セットする 人事入社情報。
	 */
	void setEntranceDto(EntranceDtoInterface entranceDto);
	
	/**
	 * @param suspensionDto セットする 人事休職情報。
	 */
	void setSuspensionDto(SuspensionDtoInterface suspensionDto);
	
	/**
	 * @param retirementDto セットする 人事退職情報。
	 */
	void setRetirementDto(RetirementDtoInterface retirementDto);
	
	/**
	 * @param concurrentList セットする 人事兼務情報。
	 */
	void setConcurrentList(List<ConcurrentDtoInterface> concurrentList);
	
}
