/*
 * MosP - Mind Open Source Project    http://www.mosp.jp/
 * Copyright (C) MIND Co., Ltd.       http://www.e-mind.co.jp/
 * 
 * This program is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package jp.mosp.setup.action;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.setup.bean.DbCreateBean;
import jp.mosp.setup.vo.DbConfirmVo;
import jp.mosp.setup.vo.DbCreateVo;

/**
 * 作成するDB名・ロール名を決定。<br>
 * 作成前に同じものが存在しないか確認をし、<br>
 * ロール名・パスワードを決定。<br>
 * 3つを作成終了時エラーがなければ、<br>
 * XMLファイルを作成し、SQLを流す。<br>
 */
public class DbCreateAction extends PlatformAction {
	
	/**
	 *  表示コマンド。<br>
	 *  初期表示を行う。<br>
	 */
	public static final String	CMD_SHOW	= "SU2000";
	
	/**
	 *  確認コマンド。<br>
	 *  接続の確認、全ての登録を行う。<br>
	 */
	public static final String	CMD_CHECK	= "SU2001";
	

	/**
	 * コマンド毎処理。<br>
	 */
	@Override
	public void action() throws MospException {
		// コマンド毎の処理
		if (mospParams.getCommand().equals(CMD_SHOW)) {
			// 表示
			prepareVo(false, false);
			show();
		} else if (mospParams.getCommand().equals(CMD_CHECK)) {
			// 新規登録
			prepareVo();
			create();
		}
	}
	
	/**
	 * 初期表示処理を行う。<br>
	 * @throws MospException 表示できなかった場合
	 */
	protected void show() throws MospException {
		// VOを呼び出す
		DbCreateVo vo = (DbCreateVo)mospParams.getVo();
		// あらかじめ項目に表示させる
		vo.setTxtDbName("mospv4");
		vo.setTxtRoleName("usermosp");
		vo.setTxtRolePw("passmosp");
	}
	
	/**
	 * DBに接続し、DB・ロールを作成。<br>
	 * SQLを流し、設定ファイルを作成、設定を上書き。<br>
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	protected void create() throws MospException {
		// VOを呼び出す
		DbConfirmVo confirmVo = (DbConfirmVo)mospParams.getStoredVo(DbConfirmVo.class.getName());
		DbCreateVo createVo = (DbCreateVo)mospParams.getVo();
		// Beanを初期化し呼び出す
		DbCreateBean bean = new DbCreateBean();
		// DBcreateBeanにmospParamsをセット
		bean.setMospParams(mospParams);
		// 接続確認のための値を代入
		String serverName = confirmVo.getTxtServer();
		String port = confirmVo.getTxtPort();
		String dbName = DbCreateBean.NAME_POSTGRES;
		String user = DbCreateBean.NAME_POSTGRES;
		String pass = confirmVo.getTxtPostgresPass();
		// 接続確認(Postgresデータベース)
		bean.createConectionn(serverName, port, dbName, user, pass);
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// initBean実行
		bean.initBean();
		// 同じDB名がないかチェック
		if (bean.checkCreateDb(createVo.getTxtDbName(), createVo.getTxtRoleName()) == false) {
			// 登録失敗メッセージ設定
			mospParams.addErrorMessage(DbCreateBean.MSG_YET, null);
			return;
		}
		// DBを作成
		bean.createDb(createVo.getTxtDbName());
		if (mospParams.hasErrorMessage()) {
			// 登録失敗メッセージ設定
			mospParams.addErrorMessage(DbCreateBean.MSG_CREATEDB, null);
			return;
		}
		// ロールを作成
		bean.createRole(createVo.getTxtRoleName(), createVo.getTxtRolePw());
		if (mospParams.hasErrorMessage()) {
			// 登録失敗メッセージ設定
			mospParams.addErrorMessage(DbCreateBean.MSG_CREATEROLE, null);
			return;
		}
		// コネクション開放
		bean.connEnd();
		// DB接続(決定したDB名で)
		dbName = createVo.getTxtDbName();
		bean.createConectionn(serverName, port, dbName, user, pass);
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// initBean実行
		bean.initBean();
		// SQLを流し込む
		bean.createTable(createVo.getTxtRoleName());
		if (mospParams.hasErrorMessage()) {
			// 登録失敗メッセージ設定
			mospParams.addErrorMessage(DbCreateBean.MSG_CONECTION, null);
			return;
		}
		// 次の画面へ
		mospParams.setNextCommand(FirstUserAction.CMD_SHOW);
		// XMLファイル作成
		bean.createXml(confirmVo.getTxtServer(), confirmVo.getTxtPort(), createVo.getTxtDbName(), createVo
			.getTxtRoleName(), createVo.getTxtRolePw());
		// アプリケーション設定変更（DB名）
		bean.setApplicationUrl(confirmVo.getTxtServer(), confirmVo.getTxtPort(), createVo.getTxtDbName());
		// アプリケーション設定変更（ロールユーザ名）
		bean.setApplicationUser(createVo.getTxtRoleName());
		// アプリケーション設定変更（DB名）
		bean.setApplicationPass(createVo.getTxtRolePw());
		// コネクション開放
		bean.connEnd();
	}
	
	/**
	 * この画面で使うVOを決めている。<br>
	 * @return 取得したVOインスタンス
	 */
	@Override
	protected DbCreateVo getSpecificVo() {
		return new DbCreateVo();
	}
}
