package jp.mosp.setup.action;

import jp.mosp.framework.base.MospException;
import jp.mosp.platform.base.PlatformAction;
import jp.mosp.platform.portal.action.IndexAction;
import jp.mosp.setup.bean.DbCreateBean;
import jp.mosp.setup.vo.XmlCreateVo;

/**
 * 
 * XMLファイルの作成が必要か確認し、
 * 必要であれば作成する。
 */
public class XmlCreateAction extends PlatformAction {
	
	/**
	 *  表示コマンド。<br>
	 *  初期表示を行う。<br>
	 */
	public static final String		CMD_SHOW	= "SU5000";
	
	/**
	 *  確認コマンド。<br>
	 *  接続の確認、XMLの作成を行う。<br>
	 */
	public static final String		CMD_CHECK	= "SU5001";
	
	/**
	 * 表示させるサーバ名。<br>
	 */
	protected static final String	SV			= "localhost";
	
	/**
	 * 表示させるポート番号。<br>
	 */
	protected static final String	PB			= "5432";
	
	/**
	 * 表示させるDB名。<br>
	 */
	protected static final String	DB			= "mospv4";
	
	/**
	 * 表示させるDBユーザ名。<br>
	 */
	protected static final String	DBU			= "usermosp";
	
	/**
	 * 表示させるDBユーザパスワード。<br>
	 */
	protected static final String	DBP			= "passmosp";
	

	/**
	 * コマンド毎処理。<br>
	 */
	@Override
	public void action() throws MospException {
		// コマンド毎の処理
		if (mospParams.getCommand().equals(CMD_SHOW)) {
			// 表示
			prepareVo(false, false);
			show();
		} else if (mospParams.getCommand().equals(CMD_CHECK)) {
			// 新規登録
			prepareVo();
			create();
		}
	}
	
	/**
	 * 初期表示処理を行う。<br>
	 * @throws MospException 表示できなかった場合
	 */
	protected void show() throws MospException {
		// Beanを初期化し呼び出す
		DbCreateBean bean = new DbCreateBean();
		// DBcreateBeanにmospParamsをセット
		bean.setMospParams(mospParams);
		// 現在のXMLからDB接続情報を取得し、接続を試みる。
		if (bean.confirmDbCreation()) {
			// 接続できたらMosPへ
			mospParams.setNextCommand(IndexAction.CMD_SHOW);
		}
		// VOを呼び出す
		XmlCreateVo vo = (XmlCreateVo)mospParams.getVo();
		// あらかじめ項目に表示させる
		vo.setTxtServer(SV);
		vo.setTxtPort(PB);
		vo.setTxtDbName(DB);
		vo.setTxtRoleName(DBU);
		vo.setTxtRolePw(DBP);
	}
	
	/**
	 * DBに接続し、DB・ロールを確認。<br>
	 * 設定ファイルを作成、設定を上書き。<br>
	 * @throws MospException インスタンスの取得或いはSQL実行に失敗した場合
	 */
	protected void create() throws MospException {
		// VOを呼び出す
		XmlCreateVo vo = (XmlCreateVo)mospParams.getStoredVo(XmlCreateVo.class.getName());
		// Beanを初期化し呼び出す
		DbCreateBean bean = new DbCreateBean();
		// DBcreateBeanにmospParamsをセット
		bean.setMospParams(mospParams);
		// 現在のXMLからDB接続情報を取得し、接続を試みる
		if (bean.confirmDbCreation()) {
			// 接続できたらMosPへ
			mospParams.setNextCommand(IndexAction.CMD_SHOW);
		}
		// 入力された値を材料にする
		String serverName = vo.getTxtServer();
		String port = vo.getTxtPort();
		String dbName = vo.getTxtDbName();
		String user = vo.getTxtRoleName();
		String pass = vo.getTxtRolePw();
		// DBなどが実在するのか接続確認(Postgresデータベース)
		bean.createConectionn(serverName, port, dbName, user, pass);
		if (mospParams.hasErrorMessage()) {
			return;
		}
		// コネクション開放
		bean.connEnd();
		// XMLファイル作成
		bean.createXml(serverName, port, dbName, user, pass);
		// アプリケーション設定変更（DB名）
		bean.setApplicationUrl(serverName, port, dbName);
		// アプリケーション設定変更（ロールユーザ名）
		bean.setApplicationUser(user);
		// アプリケーション設定変更（ロールパスワード）
		bean.setApplicationPass(pass);
		// 次の画面へ
		mospParams.setNextCommand(IndexAction.CMD_SHOW);
	}
	
	/**
	 * この画面で使うVOを決めている。<br>
	 * @return 取得したVOインスタンス
	 */
	@Override
	protected XmlCreateVo getSpecificVo() {
		return new XmlCreateVo();
	}
}
